/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.BackupAsyncClientBuilder;
import software.amazon.awssdk.services.backup.BackupServiceClientConfiguration;
import software.amazon.awssdk.services.backup.DefaultBackupAsyncClient;
import software.amazon.awssdk.services.backup.DefaultBackupBaseClientBuilder;
import software.amazon.awssdk.services.backup.endpoints.BackupEndpointProvider;

@SdkInternalApi
final class DefaultBackupAsyncClientBuilder
extends DefaultBackupBaseClientBuilder<BackupAsyncClientBuilder, BackupAsyncClient>
implements BackupAsyncClientBuilder {
    DefaultBackupAsyncClientBuilder() {
    }

    @Override
    public DefaultBackupAsyncClientBuilder endpointProvider(BackupEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BackupAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultBackupAsyncClientBuilder.validateClientOptions(clientConfiguration);
        BackupServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBackupAsyncClient client = new DefaultBackupAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BackupServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BackupServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

