/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.firehose.DefaultFirehoseAsyncClientBuilder;
import software.amazon.awssdk.services.firehose.FirehoseAsyncClientBuilder;
import software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest;
import software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsResponse;
import software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordResponse;
import software.amazon.awssdk.services.firehose.model.StartDeliveryStreamEncryptionRequest;
import software.amazon.awssdk.services.firehose.model.StartDeliveryStreamEncryptionResponse;
import software.amazon.awssdk.services.firehose.model.StopDeliveryStreamEncryptionRequest;
import software.amazon.awssdk.services.firehose.model.StopDeliveryStreamEncryptionResponse;
import software.amazon.awssdk.services.firehose.model.TagDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.TagDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.firehose.model.UpdateDestinationResponse;

@SdkPublicApi
@ThreadSafe
public interface FirehoseAsyncClient
extends SdkClient {
    public static final String SERVICE_NAME = "firehose";
    public static final String SERVICE_METADATA_ID = "firehose";

    public static FirehoseAsyncClient create() {
        return (FirehoseAsyncClient)FirehoseAsyncClient.builder().build();
    }

    public static FirehoseAsyncClientBuilder builder() {
        return new DefaultFirehoseAsyncClientBuilder();
    }

    default public CompletableFuture<CreateDeliveryStreamResponse> createDeliveryStream(CreateDeliveryStreamRequest createDeliveryStreamRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateDeliveryStreamResponse> createDeliveryStream(Consumer<CreateDeliveryStreamRequest.Builder> createDeliveryStreamRequest) {
        return this.createDeliveryStream((CreateDeliveryStreamRequest)((Object)((CreateDeliveryStreamRequest.Builder)CreateDeliveryStreamRequest.builder().applyMutation(createDeliveryStreamRequest)).build()));
    }

    default public CompletableFuture<DeleteDeliveryStreamResponse> deleteDeliveryStream(DeleteDeliveryStreamRequest deleteDeliveryStreamRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteDeliveryStreamResponse> deleteDeliveryStream(Consumer<DeleteDeliveryStreamRequest.Builder> deleteDeliveryStreamRequest) {
        return this.deleteDeliveryStream((DeleteDeliveryStreamRequest)((Object)((DeleteDeliveryStreamRequest.Builder)DeleteDeliveryStreamRequest.builder().applyMutation(deleteDeliveryStreamRequest)).build()));
    }

    default public CompletableFuture<DescribeDeliveryStreamResponse> describeDeliveryStream(DescribeDeliveryStreamRequest describeDeliveryStreamRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeDeliveryStreamResponse> describeDeliveryStream(Consumer<DescribeDeliveryStreamRequest.Builder> describeDeliveryStreamRequest) {
        return this.describeDeliveryStream((DescribeDeliveryStreamRequest)((Object)((DescribeDeliveryStreamRequest.Builder)DescribeDeliveryStreamRequest.builder().applyMutation(describeDeliveryStreamRequest)).build()));
    }

    default public CompletableFuture<ListDeliveryStreamsResponse> listDeliveryStreams(ListDeliveryStreamsRequest listDeliveryStreamsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListDeliveryStreamsResponse> listDeliveryStreams(Consumer<ListDeliveryStreamsRequest.Builder> listDeliveryStreamsRequest) {
        return this.listDeliveryStreams((ListDeliveryStreamsRequest)((Object)((ListDeliveryStreamsRequest.Builder)ListDeliveryStreamsRequest.builder().applyMutation(listDeliveryStreamsRequest)).build()));
    }

    default public CompletableFuture<ListDeliveryStreamsResponse> listDeliveryStreams() {
        return this.listDeliveryStreams((ListDeliveryStreamsRequest)((Object)ListDeliveryStreamsRequest.builder().build()));
    }

    default public CompletableFuture<ListTagsForDeliveryStreamResponse> listTagsForDeliveryStream(ListTagsForDeliveryStreamRequest listTagsForDeliveryStreamRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForDeliveryStreamResponse> listTagsForDeliveryStream(Consumer<ListTagsForDeliveryStreamRequest.Builder> listTagsForDeliveryStreamRequest) {
        return this.listTagsForDeliveryStream((ListTagsForDeliveryStreamRequest)((Object)((ListTagsForDeliveryStreamRequest.Builder)ListTagsForDeliveryStreamRequest.builder().applyMutation(listTagsForDeliveryStreamRequest)).build()));
    }

    default public CompletableFuture<PutRecordResponse> putRecord(PutRecordRequest putRecordRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutRecordResponse> putRecord(Consumer<PutRecordRequest.Builder> putRecordRequest) {
        return this.putRecord((PutRecordRequest)((Object)((PutRecordRequest.Builder)PutRecordRequest.builder().applyMutation(putRecordRequest)).build()));
    }

    default public CompletableFuture<PutRecordBatchResponse> putRecordBatch(PutRecordBatchRequest putRecordBatchRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutRecordBatchResponse> putRecordBatch(Consumer<PutRecordBatchRequest.Builder> putRecordBatchRequest) {
        return this.putRecordBatch((PutRecordBatchRequest)((Object)((PutRecordBatchRequest.Builder)PutRecordBatchRequest.builder().applyMutation(putRecordBatchRequest)).build()));
    }

    default public CompletableFuture<StartDeliveryStreamEncryptionResponse> startDeliveryStreamEncryption(StartDeliveryStreamEncryptionRequest startDeliveryStreamEncryptionRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartDeliveryStreamEncryptionResponse> startDeliveryStreamEncryption(Consumer<StartDeliveryStreamEncryptionRequest.Builder> startDeliveryStreamEncryptionRequest) {
        return this.startDeliveryStreamEncryption((StartDeliveryStreamEncryptionRequest)((Object)((StartDeliveryStreamEncryptionRequest.Builder)StartDeliveryStreamEncryptionRequest.builder().applyMutation(startDeliveryStreamEncryptionRequest)).build()));
    }

    default public CompletableFuture<StopDeliveryStreamEncryptionResponse> stopDeliveryStreamEncryption(StopDeliveryStreamEncryptionRequest stopDeliveryStreamEncryptionRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StopDeliveryStreamEncryptionResponse> stopDeliveryStreamEncryption(Consumer<StopDeliveryStreamEncryptionRequest.Builder> stopDeliveryStreamEncryptionRequest) {
        return this.stopDeliveryStreamEncryption((StopDeliveryStreamEncryptionRequest)((Object)((StopDeliveryStreamEncryptionRequest.Builder)StopDeliveryStreamEncryptionRequest.builder().applyMutation(stopDeliveryStreamEncryptionRequest)).build()));
    }

    default public CompletableFuture<TagDeliveryStreamResponse> tagDeliveryStream(TagDeliveryStreamRequest tagDeliveryStreamRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagDeliveryStreamResponse> tagDeliveryStream(Consumer<TagDeliveryStreamRequest.Builder> tagDeliveryStreamRequest) {
        return this.tagDeliveryStream((TagDeliveryStreamRequest)((Object)((TagDeliveryStreamRequest.Builder)TagDeliveryStreamRequest.builder().applyMutation(tagDeliveryStreamRequest)).build()));
    }

    default public CompletableFuture<UntagDeliveryStreamResponse> untagDeliveryStream(UntagDeliveryStreamRequest untagDeliveryStreamRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagDeliveryStreamResponse> untagDeliveryStream(Consumer<UntagDeliveryStreamRequest.Builder> untagDeliveryStreamRequest) {
        return this.untagDeliveryStream((UntagDeliveryStreamRequest)((Object)((UntagDeliveryStreamRequest.Builder)UntagDeliveryStreamRequest.builder().applyMutation(untagDeliveryStreamRequest)).build()));
    }

    default public CompletableFuture<UpdateDestinationResponse> updateDestination(UpdateDestinationRequest updateDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateDestinationResponse> updateDestination(Consumer<UpdateDestinationRequest.Builder> updateDestinationRequest) {
        return this.updateDestination((UpdateDestinationRequest)((Object)((UpdateDestinationRequest.Builder)UpdateDestinationRequest.builder().applyMutation(updateDestinationRequest)).build()));
    }
}

