/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.ListOfDiscardedFilesCopier;
import software.amazon.awssdk.services.lookoutequipment.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngestedFilesSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngestedFilesSummary> {
    private static final SdkField<Integer> TOTAL_NUMBER_OF_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalNumberOfFiles").getter(IngestedFilesSummary.getter(IngestedFilesSummary::totalNumberOfFiles)).setter(IngestedFilesSummary.setter(Builder::totalNumberOfFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfFiles").build()}).build();
    private static final SdkField<Integer> INGESTED_NUMBER_OF_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IngestedNumberOfFiles").getter(IngestedFilesSummary.getter(IngestedFilesSummary::ingestedNumberOfFiles)).setter(IngestedFilesSummary.setter(Builder::ingestedNumberOfFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestedNumberOfFiles").build()}).build();
    private static final SdkField<List<S3Object>> DISCARDED_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DiscardedFiles").getter(IngestedFilesSummary.getter(IngestedFilesSummary::discardedFiles)).setter(IngestedFilesSummary.setter(Builder::discardedFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscardedFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_NUMBER_OF_FILES_FIELD, INGESTED_NUMBER_OF_FILES_FIELD, DISCARDED_FILES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer totalNumberOfFiles;
    private final Integer ingestedNumberOfFiles;
    private final List<S3Object> discardedFiles;

    private IngestedFilesSummary(BuilderImpl builder) {
        this.totalNumberOfFiles = builder.totalNumberOfFiles;
        this.ingestedNumberOfFiles = builder.ingestedNumberOfFiles;
        this.discardedFiles = builder.discardedFiles;
    }

    public final Integer totalNumberOfFiles() {
        return this.totalNumberOfFiles;
    }

    public final Integer ingestedNumberOfFiles() {
        return this.ingestedNumberOfFiles;
    }

    public final boolean hasDiscardedFiles() {
        return this.discardedFiles != null && !(this.discardedFiles instanceof SdkAutoConstructList);
    }

    public final List<S3Object> discardedFiles() {
        return this.discardedFiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestedNumberOfFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiscardedFiles() ? this.discardedFiles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestedFilesSummary)) {
            return false;
        }
        IngestedFilesSummary other = (IngestedFilesSummary)obj;
        return Objects.equals(this.totalNumberOfFiles(), other.totalNumberOfFiles()) && Objects.equals(this.ingestedNumberOfFiles(), other.ingestedNumberOfFiles()) && this.hasDiscardedFiles() == other.hasDiscardedFiles() && Objects.equals(this.discardedFiles(), other.discardedFiles());
    }

    public final String toString() {
        return ToString.builder((String)"IngestedFilesSummary").add("TotalNumberOfFiles", (Object)this.totalNumberOfFiles()).add("IngestedNumberOfFiles", (Object)this.ingestedNumberOfFiles()).add("DiscardedFiles", this.hasDiscardedFiles() ? this.discardedFiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalNumberOfFiles": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfFiles()));
            }
            case "IngestedNumberOfFiles": {
                return Optional.ofNullable(clazz.cast(this.ingestedNumberOfFiles()));
            }
            case "DiscardedFiles": {
                return Optional.ofNullable(clazz.cast(this.discardedFiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestedFilesSummary, T> g) {
        return obj -> g.apply((IngestedFilesSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalNumberOfFiles;
        private Integer ingestedNumberOfFiles;
        private List<S3Object> discardedFiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IngestedFilesSummary model) {
            this.totalNumberOfFiles(model.totalNumberOfFiles);
            this.ingestedNumberOfFiles(model.ingestedNumberOfFiles);
            this.discardedFiles(model.discardedFiles);
        }

        public final Integer getTotalNumberOfFiles() {
            return this.totalNumberOfFiles;
        }

        public final void setTotalNumberOfFiles(Integer totalNumberOfFiles) {
            this.totalNumberOfFiles = totalNumberOfFiles;
        }

        @Override
        public final Builder totalNumberOfFiles(Integer totalNumberOfFiles) {
            this.totalNumberOfFiles = totalNumberOfFiles;
            return this;
        }

        public final Integer getIngestedNumberOfFiles() {
            return this.ingestedNumberOfFiles;
        }

        public final void setIngestedNumberOfFiles(Integer ingestedNumberOfFiles) {
            this.ingestedNumberOfFiles = ingestedNumberOfFiles;
        }

        @Override
        public final Builder ingestedNumberOfFiles(Integer ingestedNumberOfFiles) {
            this.ingestedNumberOfFiles = ingestedNumberOfFiles;
            return this;
        }

        public final List<S3Object.Builder> getDiscardedFiles() {
            List<S3Object.Builder> result = ListOfDiscardedFilesCopier.copyToBuilder(this.discardedFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDiscardedFiles(Collection<S3Object.BuilderImpl> discardedFiles) {
            this.discardedFiles = ListOfDiscardedFilesCopier.copyFromBuilder(discardedFiles);
        }

        @Override
        public final Builder discardedFiles(Collection<S3Object> discardedFiles) {
            this.discardedFiles = ListOfDiscardedFilesCopier.copy(discardedFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder discardedFiles(S3Object ... discardedFiles) {
            this.discardedFiles(Arrays.asList(discardedFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder discardedFiles(Consumer<S3Object.Builder> ... discardedFiles) {
            this.discardedFiles(Stream.of(discardedFiles).map(c -> (S3Object)((S3Object.Builder)S3Object.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IngestedFilesSummary build() {
            return new IngestedFilesSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngestedFilesSummary> {
        public Builder totalNumberOfFiles(Integer var1);

        public Builder ingestedNumberOfFiles(Integer var1);

        public Builder discardedFiles(Collection<S3Object> var1);

        public Builder discardedFiles(S3Object ... var1);

        public Builder discardedFiles(Consumer<S3Object.Builder> ... var1);
    }
}

