/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse;

public class ListModelsIterable
implements SdkIterable<ListModelsResponse> {
    private final LookoutEquipmentClient client;
    private final ListModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelsIterable(LookoutEquipmentClient client, ListModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListModelsResponseFetcher();
    }

    public Iterator<ListModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListModelsResponseFetcher
    implements SyncPageFetcher<ListModelsResponse> {
        private ListModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelsResponse nextPage(ListModelsResponse previousPage) {
            if (previousPage == null) {
                return ListModelsIterable.this.client.listModels(ListModelsIterable.this.firstRequest);
            }
            return ListModelsIterable.this.client.listModels((ListModelsRequest)((Object)ListModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

