/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescription;
import software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescriptionListCopier;
import software.amazon.awssdk.services.qldb.model.QldbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJournalKinesisStreamsForLedgerResponse
extends QldbResponse
implements ToCopyableBuilder<Builder, ListJournalKinesisStreamsForLedgerResponse> {
    private static final SdkField<List<JournalKinesisStreamDescription>> STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Streams").getter(ListJournalKinesisStreamsForLedgerResponse.getter(ListJournalKinesisStreamsForLedgerResponse::streams)).setter(ListJournalKinesisStreamsForLedgerResponse.setter(Builder::streams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Streams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JournalKinesisStreamDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListJournalKinesisStreamsForLedgerResponse.getter(ListJournalKinesisStreamsForLedgerResponse::nextToken)).setter(ListJournalKinesisStreamsForLedgerResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<JournalKinesisStreamDescription> streams;
    private final String nextToken;

    private ListJournalKinesisStreamsForLedgerResponse(BuilderImpl builder) {
        super(builder);
        this.streams = builder.streams;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStreams() {
        return this.streams != null && !(this.streams instanceof SdkAutoConstructList);
    }

    public final List<JournalKinesisStreamDescription> streams() {
        return this.streams;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreams() ? this.streams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJournalKinesisStreamsForLedgerResponse)) {
            return false;
        }
        ListJournalKinesisStreamsForLedgerResponse other = (ListJournalKinesisStreamsForLedgerResponse)((Object)obj);
        return this.hasStreams() == other.hasStreams() && Objects.equals(this.streams(), other.streams()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListJournalKinesisStreamsForLedgerResponse").add("Streams", this.hasStreams() ? this.streams() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Streams": {
                return Optional.ofNullable(clazz.cast(this.streams()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJournalKinesisStreamsForLedgerResponse, T> g) {
        return obj -> g.apply((ListJournalKinesisStreamsForLedgerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbResponse.BuilderImpl
    implements Builder {
        private List<JournalKinesisStreamDescription> streams = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJournalKinesisStreamsForLedgerResponse model) {
            super(model);
            this.streams(model.streams);
            this.nextToken(model.nextToken);
        }

        public final List<JournalKinesisStreamDescription.Builder> getStreams() {
            List<JournalKinesisStreamDescription.Builder> result = JournalKinesisStreamDescriptionListCopier.copyToBuilder(this.streams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreams(Collection<JournalKinesisStreamDescription.BuilderImpl> streams) {
            this.streams = JournalKinesisStreamDescriptionListCopier.copyFromBuilder(streams);
        }

        @Override
        public final Builder streams(Collection<JournalKinesisStreamDescription> streams) {
            this.streams = JournalKinesisStreamDescriptionListCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(JournalKinesisStreamDescription ... streams) {
            this.streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<JournalKinesisStreamDescription.Builder> ... streams) {
            this.streams(Stream.of(streams).map(c -> (JournalKinesisStreamDescription)((JournalKinesisStreamDescription.Builder)JournalKinesisStreamDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJournalKinesisStreamsForLedgerResponse build() {
            return new ListJournalKinesisStreamsForLedgerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QldbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJournalKinesisStreamsForLedgerResponse> {
        public Builder streams(Collection<JournalKinesisStreamDescription> var1);

        public Builder streams(JournalKinesisStreamDescription ... var1);

        public Builder streams(Consumer<JournalKinesisStreamDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

