/*
 * Decompiled with CFR 0.152.
 */
package com.bianxianmao.offlinemodel.alg;

import com.bianxianmao.offlinemodel.alg.BaseAlgorithm;
import com.bianxianmao.offlinemodel.alg.IAlgorithm;
import com.bianxianmao.offlinemodel.alg.util.FMModelUtil;
import com.bianxianmao.offlinemodel.alg.vo.VectorResult;
import com.bianxianmao.offlinemodel.api.PredResultVo;
import com.bianxianmao.offlinemodel.api.dto.AdvertModelEntity;
import com.bianxianmao.offlinemodel.api.enums.SerializerEnum;
import com.bianxianmao.offlinemodel.mllib.model.SparseFMModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.spark.mllib.linalg.SparseVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FM
extends BaseAlgorithm
implements Serializable,
IAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(FM.class);
    private FMModelUtil modelUtil = null;

    public FMModelUtil getModelUtil() {
        if (this.modelUtil == null) {
            this.modelUtil = new FMModelUtil();
        }
        return this.modelUtil;
    }

    public FM() {
    }

    public FM(String featureIdxList, String dict, String modelStr, String featureCollectionList, SerializerEnum serializerEnum) {
        this.setFeatureDict(dict, serializerEnum);
        this.setModel(modelStr, serializerEnum);
        this.setFeatureIdxList(featureIdxList, serializerEnum);
        this.setFeatureCollectionList(featureCollectionList, serializerEnum);
    }

    public FM(AdvertModelEntity entity) {
        SerializerEnum serializerEnum = entity.getSerializerId() == SerializerEnum.KRYO.getIndex() ? SerializerEnum.KRYO : SerializerEnum.JAVA_ORIGINAL;
        this.setFeatureDict(entity.getFeatureDictStr(), serializerEnum);
        this.setFeatureIdxList(entity.getFeatureIdxListStr(), serializerEnum);
        this.setFeatureCollectionList(entity.getFeatureCollectListStr(), serializerEnum);
        this.setModel(entity.getModelStr(), serializerEnum);
    }

    public void setEntity(AdvertModelEntity entity) {
        SerializerEnum serializerEnum = entity.getSerializerId() == SerializerEnum.KRYO.getIndex() ? SerializerEnum.KRYO : SerializerEnum.JAVA_ORIGINAL;
        this.setFeatureDict(entity.getFeatureDictStr(), serializerEnum);
        this.setFeatureIdxList(entity.getFeatureIdxListStr(), serializerEnum);
        this.setFeatureCollectionList(entity.getFeatureCollectListStr(), serializerEnum);
        this.setModel(entity.getModelStr(), serializerEnum);
    }

    @Override
    public void setModel(SparseFMModel model) {
        this.getModelUtil().setModel(model);
    }

    @Override
    public void setModel(String modelStr, SerializerEnum serializerEnum) {
        this.getModelUtil().setModel(modelStr, serializerEnum);
    }

    @Override
    public String getModelStr(SerializerEnum serializerEnum) {
        return this.getModelUtil().getModelStr(serializerEnum);
    }

    @Override
    public Double predict(List<String> categoryList) {
        Double ret = null;
        try {
            VectorResult vr = this.getDictUtil().oneHotSparseVectorEncode(this.getFeatureIdxList(), categoryList, this.getFeatureCollectionList());
            if (vr != null && vr.getVector() != null) {
                ret = this.getModelUtil().predict(vr.getVector());
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return ret;
    }

    @Override
    public Double predict(Map<String, String> categoryMap) {
        Double ret = null;
        try {
            VectorResult vr = this.getDictUtil().oneHotSparseVectorEncodeWithMap(this.getFeatureIdxList(), categoryMap, this.getFeatureCollectionList());
            if (vr != null && vr.getVector() != null) {
                ret = this.predictWithVector(vr.getVector());
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return ret;
    }

    public List<String> predictWithAssetArray(Map<String, String> categoryMap, String[] assetArray) {
        ArrayList<String> assetCtrPair = new ArrayList<String>();
        assetCtrPair.add("null");
        assetCtrPair.add("null");
        try {
            if (assetArray == null || assetArray.length == 0) {
                Double ctr = this.predict(categoryMap);
                assetCtrPair.set(0, "null");
                assetCtrPair.set(1, ctr.toString());
            } else {
                HashSet<String> assetSet = new HashSet<String>(Arrays.asList(assetArray));
                Double maxCtr = -1.0;
                for (String assetId : assetSet) {
                    categoryMap.put("f1008", assetId);
                    Double retCtr = this.predict(categoryMap);
                    if (!(retCtr >= maxCtr)) continue;
                    maxCtr = retCtr;
                    assetCtrPair.set(0, assetId);
                    assetCtrPair.set(1, retCtr.toString());
                }
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return assetCtrPair;
    }

    @Override
    public PredResultVo predictWithInfo(Map<String, String> categoryMap) {
        PredResultVo ret = new PredResultVo();
        try {
            VectorResult vr = this.getDictUtil().oneHotSparseVectorEncodeWithMap(this.getFeatureIdxList(), categoryMap, this.getFeatureCollectionList());
            if (vr != null && vr.getVector() != null) {
                Double predValue = this.predictWithVector(vr.getVector());
                ret.setPredValue(predValue);
                ret.setNewFeatureNums(vr.getNewFeatureNums());
                ret.setTotalFeatureNums(vr.getTotalFeatureNums());
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return ret;
    }

    public VectorResult predictWithVectorResult(Map<String, String> categoryMap) {
        VectorResult ret = new VectorResult();
        try {
            VectorResult vr = this.getDictUtil().oneHotSparseVectorEncodeWithMap(this.getFeatureIdxList(), categoryMap, this.getFeatureCollectionList());
            if (vr != null && vr.getVector() != null) {
                Double predValue = this.predictWithVector(vr.getVector());
                ret.setNewFeatureNums(vr.getNewFeatureNums());
                ret.setTotalFeatureNums(vr.getTotalFeatureNums());
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return ret;
    }

    public Double predictWithVector(SparseVector vector) {
        Double ret = null;
        try {
            if (vector != null) {
                ret = this.getModelUtil().predict(vector);
            }
        }
        catch (Exception e) {
            logger.error("predict happend error", (Throwable)e);
        }
        return ret;
    }
}

