/*
 * Decompiled with CFR 0.152.
 */
package com.bianxianmao.offlinemodel.alg.util;

import com.bianxianmao.offlinemodel.alg.vo.VectorResult;
import com.bianxianmao.offlinemodel.api.dict.CategoryFeatureDict;
import com.bianxianmao.offlinemodel.api.enums.SerializerEnum;
import com.bianxianmao.offlinemodel.common.util.AssertUtil;
import com.bianxianmao.offlinemodel.common.util.OneHotUtil;
import com.bianxianmao.offlinemodel.common.util.serialize.KryoUtil;
import com.bianxianmao.offlinemodel.common.util.serialize.SerializeTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryFeatureDictUtil
implements Serializable {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private static final long serialVersionUID = -316102112618444930L;
    private CategoryFeatureDict dict = null;
    private Map<String, Map<String, Long>> cache = new HashMap<String, Map<String, Long>>();

    public void setFeatureDict(CategoryFeatureDict dict) {
        this.dict = dict;
    }

    public void setFeatureDict(String dictStr, SerializerEnum serializerEnum) {
        this.dict = this.getFeatureDict(dictStr, serializerEnum);
    }

    public CategoryFeatureDict getFeatureDict() {
        return this.dict;
    }

    public CategoryFeatureDict getFeatureDict(String dictStr, SerializerEnum serializerEnum) {
        CategoryFeatureDict dict = null;
        if (serializerEnum == SerializerEnum.JAVA_ORIGINAL) {
            dict = (CategoryFeatureDict)SerializeTool.getObjectFromString((String)dictStr);
        }
        if (serializerEnum == SerializerEnum.KRYO) {
            dict = (CategoryFeatureDict)KryoUtil.deserializationObject((String)dictStr, CategoryFeatureDict.class);
        }
        return dict;
    }

    public String featureIdxList2Str(List<String> idxStr, SerializerEnum serializerEnum) {
        String ret = null;
        if (serializerEnum == SerializerEnum.JAVA_ORIGINAL) {
            ret = SerializeTool.object2String(idxStr);
        }
        if (serializerEnum == SerializerEnum.KRYO) {
            ret = KryoUtil.serializationListObject(idxStr);
        }
        return ret;
    }

    public List<String> getFeatureIdxList(String featureIdxStr, SerializerEnum serializerEnum) {
        List ret = null;
        if (serializerEnum == SerializerEnum.JAVA_ORIGINAL) {
            ret = (List)SerializeTool.getObjectFromStr((String)featureIdxStr);
        }
        if (serializerEnum == SerializerEnum.KRYO) {
            ret = KryoUtil.deserializationListObject((String)featureIdxStr);
        }
        return ret;
    }

    public List<String> getFeatureCollectionList(String featureCollectionStr, SerializerEnum serializerEnum) {
        List ret = null;
        if (serializerEnum == SerializerEnum.JAVA_ORIGINAL) {
            ret = (List)SerializeTool.getObjectFromStr((String)featureCollectionStr);
        }
        if (serializerEnum == SerializerEnum.KRYO) {
            ret = KryoUtil.deserializationListObject((String)featureCollectionStr);
        }
        return ret;
    }

    public String featureCollectionList2Str(List<String> idxCollectionStr, SerializerEnum serializerEnum) {
        String ret = null;
        if (serializerEnum == SerializerEnum.JAVA_ORIGINAL) {
            ret = SerializeTool.object2String(idxCollectionStr);
        }
        if (serializerEnum == SerializerEnum.KRYO) {
            ret = KryoUtil.serializationListObject(idxCollectionStr);
        }
        return ret;
    }

    public String getFeatureDictStr(CategoryFeatureDict dict, SerializerEnum serializerEnum) {
        String ret = null;
        if (serializerEnum == SerializerEnum.JAVA_ORIGINAL) {
            ret = SerializeTool.object2String((Object)dict);
        }
        if (serializerEnum == SerializerEnum.KRYO) {
            ret = KryoUtil.serializationObject((Serializable)dict);
        }
        return ret;
    }

    public String getFeatureDictStr(SerializerEnum serializerEnum) {
        return this.getFeatureDictStr(this.dict, serializerEnum);
    }

    public List<String> getFeature(String featureIdx) {
        if (this.dict == null) {
            this.logger.warn("dict is null");
            return null;
        }
        if (AssertUtil.isEmpty((String)featureIdx)) {
            this.logger.warn("getFeature cn.com.duiba.nezha.compute.biz.param invalid");
            return null;
        }
        return (List)this.dict.getFeatureDict().get(featureIdx);
    }

    public int getFeatureSize(String featureIdx) {
        int ret = 0;
        List<String> featureMap = this.getFeature(featureIdx);
        if (AssertUtil.isNotEmpty(featureMap)) {
            ret = featureMap.size();
        }
        return ret;
    }

    public int getFeatureCategoryIndex(String featureIdx, String category) {
        int ret = -1;
        if (AssertUtil.isNotEmpty((String)featureIdx)) {
            Long ret2;
            Map<String, Long> featureMap = this.cache.get(featureIdx);
            if (featureMap == null) {
                List<String> featureList = this.getFeature(featureIdx);
                featureMap = this.categoryList2Map(featureList);
                this.cache.put(featureIdx, featureMap);
            }
            if ((ret2 = featureMap.get(category)) != null) {
                ret = ret2.intValue();
            }
        }
        return ret;
    }

    public List<Long> getFeatureCategoryIndex(String featureIdx, String category, boolean isCollection) {
        ArrayList<Long> ret = new ArrayList<Long>();
        ret.add(-1L);
        if (AssertUtil.isNotEmpty((String)featureIdx)) {
            Long ret3;
            String[] categoryArray;
            Map<String, Long> featureMap = this.cache.get(featureIdx);
            if (featureMap == null) {
                List<String> featureList = this.getFeature(featureIdx);
                featureMap = this.categoryList2Map(featureList);
                this.cache.put(featureIdx, featureMap);
            }
            if (isCollection && AssertUtil.isNotEmpty((String)category) && (categoryArray = category.split(",", 0)) != null) {
                HashSet<Long> retSet = new HashSet<Long>();
                for (String c : categoryArray) {
                    Long r = featureMap.get(c);
                    if (r != null) {
                        retSet.add(r);
                        continue;
                    }
                    retSet.add(-1L);
                }
                ArrayList ret2 = new ArrayList(retSet);
                Collections.sort(ret2);
                ret = ret2;
            }
            if (!isCollection && AssertUtil.isNotEmpty((String)category) && (ret3 = featureMap.get(category)) != null) {
                ret.clear();
                ret.add(ret3);
            }
        }
        return ret;
    }

    public Map<String, Long> categoryList2Map(List<String> featureCateList) {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        if (AssertUtil.isNotEmpty(featureCateList)) {
            int size = featureCateList.size();
            for (int i = 0; i < size; ++i) {
                ret.put(featureCateList.get(i), Long.valueOf(i));
            }
        }
        return ret;
    }

    public double[] featureOneHotDoubleEncode(String featureIdx, String category) {
        double[] ret = null;
        int idx = this.getFeatureCategoryIndex(featureIdx, category);
        int size = this.getFeatureSize(featureIdx);
        if (AssertUtil.isNotEmpty((Object)idx)) {
            ret = OneHotUtil.getOneHotDouble((int)idx, (int)size);
        }
        return ret;
    }

    public double[] oneHotDoubleEncode(List<String> featureIdxList, List<String> categoryList) {
        double[] ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureIdxList, categoryList}) || categoryList.size() != featureIdxList.size()) {
            return null;
        }
        try {
            for (int i = 0; i < featureIdxList.size(); ++i) {
                String category;
                String featureIdx = featureIdxList.get(i);
                double[] partRet = this.featureOneHotDoubleEncode(featureIdx, category = categoryList.get(i));
                if (partRet == null) {
                    return null;
                }
                ret = ArrayUtils.addAll(ret, (double[])partRet);
            }
        }
        catch (Exception e) {
            this.logger.error("oneHotDoubleEncode happend error", (Throwable)e);
        }
        return ret;
    }

    public SparseVector oneHotSparseVectorEncode(List<String> featureIdxList, List<String> categoryList) {
        SparseVector ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureIdxList, categoryList}) || categoryList.size() != featureIdxList.size()) {
            return null;
        }
        try {
            int[] sizeArray = new int[featureIdxList.size()];
            int[] indexArray = new int[featureIdxList.size()];
            int[] r_indices = new int[featureIdxList.size()];
            double[] r_values = new double[featureIdxList.size()];
            int sizeSum = 0;
            for (int i = 0; i < featureIdxList.size(); ++i) {
                String featureIdx = featureIdxList.get(i);
                String category = categoryList.get(i);
                sizeArray[i] = this.getFeatureSize(featureIdx);
                indexArray[i] = this.getFeatureCategoryIndex(featureIdx, category);
                r_indices[i] = sizeSum + this.getFeatureCategoryIndex(featureIdx, category) + 1;
                sizeSum += this.getFeatureSize(featureIdx) + 1;
                r_values[i] = 1.0;
            }
            ret = (SparseVector)Vectors.sparse((int)sizeSum, (int[])r_indices, (double[])r_values);
        }
        catch (Exception e) {
            this.logger.error("oneHotDoubleEncode happend error", (Throwable)e);
        }
        return ret;
    }

    public boolean isCollection(String featureIdx, Set<String> featureCollectionSet) {
        boolean ret = false;
        if (featureIdx != null && featureCollectionSet != null && featureCollectionSet.contains(featureIdx)) {
            ret = true;
        }
        return ret;
    }

    public int[] toIntArray(List<Long> oList) {
        int[] ret = null;
        if (AssertUtil.isNotEmpty(oList)) {
            ret = new int[oList.size()];
            for (int i = 0; i < oList.size(); ++i) {
                Long v = oList.get(i);
                ret[i] = v != null ? v.intValue() : 0;
            }
        }
        return ret;
    }

    public double[] toDoubleArray(List<Double> oList) {
        double[] ret = null;
        if (AssertUtil.isNotEmpty(oList)) {
            ret = new double[oList.size()];
            for (int i = 0; i < oList.size(); ++i) {
                Double v = oList.get(i);
                ret[i] = v != null ? v : 0.0;
            }
        }
        return ret;
    }

    public VectorResult oneHotSparseVectorEncode(List<String> featureIdxList, List<String> categoryList, List<String> featureCollectionList) {
        VectorResult ret = new VectorResult();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureIdxList, categoryList}) || categoryList.size() != featureIdxList.size()) {
            return null;
        }
        int newFeatureNums = 0;
        int totalFeatureNums = featureIdxList.size();
        try {
            ArrayList<Long> r_indices = new ArrayList<Long>();
            ArrayList<Double> r_values = new ArrayList<Double>();
            int sizeSum = 0;
            HashSet<String> featureCollectionSet = new HashSet<String>();
            if (featureCollectionList != null) {
                featureCollectionSet.addAll(featureCollectionList);
            }
            for (int i = 0; i < totalFeatureNums; ++i) {
                String featureIdx = featureIdxList.get(i);
                String category = categoryList.get(i);
                boolean isc = this.isCollection(featureIdx, featureCollectionSet);
                List<Long> indexList = this.getFeatureCategoryIndex(featureIdx, category, isc);
                int idxSize = indexList.size();
                for (Long idx : indexList) {
                    if (idx == -1L) {
                        ++newFeatureNums;
                    }
                    r_indices.add(idx + (long)sizeSum + 1L);
                    r_values.add(1.0 / (double)idxSize);
                }
                sizeSum += this.getFeatureSize(featureIdx) + 1;
            }
            SparseVector vector = (SparseVector)Vectors.sparse((int)sizeSum, (int[])this.toIntArray(r_indices), (double[])this.toDoubleArray(r_values));
            ret.setVector(vector);
            ret.setNewFeatureNums(newFeatureNums);
            ret.setTotalFeatureNums(totalFeatureNums);
        }
        catch (Exception e) {
            this.logger.error("oneHotDoubleEncode happend error", (Throwable)e);
        }
        return ret;
    }

    public double[] oneHotDoubleEncodeWithMap(List<String> featureIdxList, Map<String, String> categoryMap) {
        double[] ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureIdxList, categoryMap})) {
            return null;
        }
        try {
            ret = this.oneHotDoubleEncodeWithMap(featureIdxList, categoryMap, true);
        }
        catch (Exception e) {
            this.logger.error("oneHotIntEncode happend error", (Throwable)e);
        }
        return ret;
    }

    public double[] oneHotDoubleEncodeWithMap(List<String> featureIdxList, Map<String, String> categoryMap, boolean ignoreNull) {
        double[] ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureIdxList, categoryMap})) {
            return null;
        }
        try {
            int status = 1;
            ArrayList<String> categoryList = new ArrayList<String>();
            for (int i = 0; i < featureIdxList.size(); ++i) {
                String featureIdx = featureIdxList.get(i);
                if (!categoryMap.containsKey(featureIdx) && !ignoreNull) {
                    status = -1;
                    break;
                }
                String category = categoryMap.get(featureIdx);
                if (category != null) {
                    category = category.toLowerCase();
                }
                categoryList.add(category);
            }
            if (status == 1) {
                ret = this.oneHotDoubleEncode(featureIdxList, categoryList);
            }
        }
        catch (Exception e) {
            this.logger.error("oneHotIntEncode happend error", (Throwable)e);
        }
        return ret;
    }

    public SparseVector oneHotSparseVectorEncodeWithMap(List<String> featureIdxList, Map<String, String> categoryMap) {
        SparseVector ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureIdxList, categoryMap})) {
            return null;
        }
        try {
            ret = this.oneHotSparseVectorEncodeWithMap(featureIdxList, categoryMap, true);
        }
        catch (Exception e) {
            this.logger.error("oneHotIntEncode happend error", (Throwable)e);
        }
        return ret;
    }

    public VectorResult oneHotSparseVectorEncodeWithMap(List<String> featureIdxList, Map<String, String> categoryMap, List<String> featureCollectionList) {
        VectorResult ret = new VectorResult();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureIdxList, categoryMap})) {
            System.out.println("isAnyEmpty(featureIdxList, categoryMap)");
            return null;
        }
        try {
            ret = this.oneHotSparseVectorEncodeWithMap(featureIdxList, categoryMap, true, featureCollectionList);
        }
        catch (Exception e) {
            this.logger.error("oneHotIntEncode happend error", (Throwable)e);
        }
        return ret;
    }

    public VectorResult oneHotSparseVectorEncodeWithMap(List<String> featureIdxList, Map<String, String> categoryMap, boolean ignoreNull, List<String> featureCollectionList) {
        VectorResult ret = new VectorResult();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureIdxList, categoryMap})) {
            return null;
        }
        try {
            int status = 1;
            ArrayList<String> categoryList = new ArrayList<String>();
            for (int i = 0; i < featureIdxList.size(); ++i) {
                String featureIdx = featureIdxList.get(i);
                if (!categoryMap.containsKey(featureIdx) && !ignoreNull) {
                    status = -1;
                    break;
                }
                String category = categoryMap.get(featureIdx);
                if (category != null) {
                    category = category.toLowerCase();
                }
                categoryList.add(category);
            }
            if (status == 1) {
                ret = this.oneHotSparseVectorEncode(featureIdxList, categoryList, featureCollectionList);
            }
        }
        catch (Exception e) {
            this.logger.error("oneHotIntEncode happend error", (Throwable)e);
        }
        return ret;
    }

    public SparseVector oneHotSparseVectorEncodeWithMap(List<String> featureIdxList, Map<String, String> categoryMap, boolean ignoreNull) {
        SparseVector ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{featureIdxList, categoryMap})) {
            return null;
        }
        try {
            int status = 1;
            ArrayList<String> categoryList = new ArrayList<String>();
            for (int i = 0; i < featureIdxList.size(); ++i) {
                String featureIdx = featureIdxList.get(i);
                if (!categoryMap.containsKey(featureIdx) && !ignoreNull) {
                    status = -1;
                    break;
                }
                String category = categoryMap.get(featureIdx);
                if (category != null) {
                    category = category.toLowerCase();
                }
                categoryList.add(category);
            }
            if (status == 1) {
                ret = this.oneHotSparseVectorEncode(featureIdxList, categoryList);
            }
        }
        catch (Exception e) {
            this.logger.error("oneHotIntEncode happend error", (Throwable)e);
        }
        return ret;
    }
}

