/*
 * Decompiled with CFR 0.152.
 */
package com.bianxianmao.offlinemodel.alg.util;

import com.alibaba.fastjson.JSONObject;
import com.bianxianmao.offlinemodel.alg.FM;
import com.bianxianmao.offlinemodel.api.PredResultVo;
import com.bianxianmao.offlinemodel.api.point.Point;
import com.bianxianmao.offlinemodel.api.vo.AlgFeatureVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;

public class ReplayerUtil
implements Serializable {
    private static final long serialVersionUID = -316102112618444922L;
    private FM model = null;
    private Map<String, AlgFeatureVo> featuremap = null;

    public void setModel(FM model) {
        this.model = model;
    }

    public FM getModel() {
        return this.model;
    }

    public void setFeaturemap() {
        this.featuremap = this.setAlgFeatureMap();
    }

    public Map<String, AlgFeatureVo> getFeaturemap() {
        if (this.featuremap == null) {
            this.setFeaturemap();
        }
        return this.featuremap;
    }

    public List<Point.ModelFeature> getFeatureInfoList() throws Exception {
        ArrayList<Point.ModelFeature> ret = new ArrayList<Point.ModelFeature>();
        if (this.featuremap == null) {
            this.setFeaturemap();
        }
        for (AlgFeatureVo algFeatureVo : this.featuremap.values()) {
            Point.ModelFeature modelFeature = new Point.ModelFeature(algFeatureVo.getFeatureId(), algFeatureVo.getCategory(), algFeatureVo.getFeatureCategorySize().longValue(), algFeatureVo.getIndex().longValue(), algFeatureVo.getSubIndex().longValue(), algFeatureVo.getIntercept().doubleValue(), algFeatureVo.getWeight().doubleValue(), algFeatureVo.getFactor());
            ret.add(modelFeature);
        }
        return ret;
    }

    public void predictWithInfo(Map<String, String> featureIdxMap) {
        PredResultVo ret = new PredResultVo();
        HashMap featureMap = new HashMap();
        try {
            List<String> featureIdxList = this.getModel().getFeatureIdxList();
            List<String> featureCollectionList = this.getModel().getFeatureCollectionList();
            for (String featureIdx : featureIdxList) {
                if (featureCollectionList.contains(featureIdx) && featureIdxMap.get(featureIdx) != null) {
                    String[] categoryArray;
                    for (String category : categoryArray = featureIdxMap.get(featureIdx).split(",", 0)) {
                        this.print(featureIdx, category);
                    }
                    continue;
                }
                this.print(featureIdx, featureIdxMap.get(featureIdx));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void print(String feature, String category) {
        try {
            if (category != null) {
                category = category.toLowerCase();
            }
            if (this.getFeaturemap().containsKey(feature + "_" + category)) {
                System.out.println(feature + "_" + category + "," + JSONObject.toJSONString((Object)this.getFeaturemap().get(feature + "_" + category)));
            } else {
                System.out.println(feature + "_" + category + "," + JSONObject.toJSONString((Object)this.getFeaturemap().get(feature + "_" + null)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map<String, AlgFeatureVo> setAlgFeatureMap() {
        HashMap<String, AlgFeatureVo> ret = new HashMap<String, AlgFeatureVo>();
        try {
            List<String> featureIdxList = this.getModel().getFeatureIdxList();
            int totalFeatureNums = featureIdxList.size();
            Point.FMModelParams params = this.getModel().getModelUtil().getModel().getFMModelParams();
            Vector w = params.w();
            Matrix v = params.v();
            Double w0 = params.w0();
            int sizeSum = 0;
            for (int i = 0; i < totalFeatureNums; ++i) {
                String featureIdx = featureIdxList.get(i);
                List<String> categoryList = this.getModel().getDictUtil().getFeature(featureIdx);
                if (categoryList == null) {
                    categoryList = new ArrayList<String>();
                }
                int categorySize = categoryList.size();
                int categoryIdxNull = sizeSum;
                Double categoryWNull = w.apply(categoryIdxNull);
                ArrayList<Double> categoryVNull = new ArrayList<Double>();
                for (int k = 0; k < v.numCols(); ++k) {
                    categoryVNull.add(v.apply(categoryIdxNull, k));
                }
                AlgFeatureVo algFeatureVo1 = new AlgFeatureVo();
                algFeatureVo1.setFeatureId(featureIdx);
                algFeatureVo1.setFactor(JSONObject.toJSONString(categoryVNull));
                algFeatureVo1.setIndex(Long.valueOf(categoryIdxNull));
                algFeatureVo1.setWeight(categoryWNull);
                algFeatureVo1.setCategory(null);
                algFeatureVo1.setFeatureCategorySize(Long.valueOf(categorySize));
                algFeatureVo1.setSubIndex(Long.valueOf(-1L));
                algFeatureVo1.setIntercept(w0);
                ret.put(featureIdx + "_" + null, algFeatureVo1);
                for (int j = 0; j < categorySize; ++j) {
                    String category = categoryList.get(j);
                    int categoryIdx = sizeSum + j + 1;
                    Double categoryW = w.apply(categoryIdx);
                    ArrayList<Double> categoryV = new ArrayList<Double>();
                    for (int k2 = 0; k2 < v.numCols(); ++k2) {
                        categoryV.add(v.apply(categoryIdx, k2));
                    }
                    AlgFeatureVo algFeatureVo = new AlgFeatureVo();
                    algFeatureVo.setFeatureId(featureIdx);
                    algFeatureVo.setFactor(JSONObject.toJSONString(categoryV));
                    algFeatureVo.setIndex(Long.valueOf(categoryIdx));
                    algFeatureVo.setWeight(categoryW);
                    algFeatureVo.setCategory(category);
                    algFeatureVo.setFeatureCategorySize(Long.valueOf(categorySize));
                    algFeatureVo.setSubIndex(Long.valueOf(j));
                    algFeatureVo.setIntercept(w0);
                    ret.put(featureIdx + "_" + category, algFeatureVo);
                }
                sizeSum += categorySize + 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void getFactorList(Matrix v) {
    }
}

