/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;

public class UnicodeUtil {
    public static String toString(String unicode) {
        if (StrUtil.isBlank(unicode)) {
            return unicode;
        }
        int len = unicode.length();
        StrBuilder sb = StrBuilder.create(len);
        int i = -1;
        int pos = 0;
        while ((i = unicode.indexOf("\\u", pos)) != -1) {
            sb.append(unicode, pos, i);
            if (i + 5 >= len) continue;
            pos = i + 6;
            sb.append((char)Integer.parseInt(unicode.substring(i + 2, i + 6), 16));
        }
        if (pos < len) {
            sb.append(unicode, pos, len);
        }
        return sb.toString();
    }

    public static String toUnicode(String str) {
        return UnicodeUtil.toUnicode(str, true);
    }

    public static String toUnicode(String str, boolean isSkipAscii) {
        if (StrUtil.isBlank(str)) {
            return str;
        }
        int len = str.length();
        StrBuilder unicode = StrBuilder.create(str.length() * 6);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (isSkipAscii && CharUtil.isAsciiPrintable(c)) {
                unicode.append(c);
                continue;
            }
            unicode.append(HexUtil.toUnicodeHex(c));
        }
        return unicode.toString();
    }
}

