/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.ScrollResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ScrollRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Time scroll;
    private final String scrollId;
    public static final JsonpDeserializer<ScrollRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScrollRequest::setupScrollRequestDeserializer);
    public static final SimpleEndpoint<ScrollRequest, ?> _ENDPOINT = new SimpleEndpoint<ScrollRequest, ScrollResponse<Object>>("es/scroll", request -> "POST", request -> "/_search/scroll", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ScrollResponse._DESERIALIZER);

    private ScrollRequest(Builder builder) {
        this.scroll = builder.scroll;
        this.scrollId = ApiTypeHelper.requireNonNull(builder.scrollId, this, "scrollId");
    }

    public static ScrollRequest of(Function<Builder, ObjectBuilder<ScrollRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time scroll() {
        return this.scroll;
    }

    public final String scrollId() {
        return this.scrollId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.scroll != null) {
            generator.writeKey("scroll");
            this.scroll.serialize(generator, mapper);
        }
        generator.writeKey("scroll_id");
        generator.write(this.scrollId);
    }

    protected static void setupScrollRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::scroll, Time._DESERIALIZER, "scroll");
        op.add(Builder::scrollId, JsonpDeserializer.stringDeserializer(), "scroll_id");
    }

    public static <TDocument> Endpoint<ScrollRequest, ScrollResponse<TDocument>, ErrorResponse> createScrollEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(ScrollResponse.createScrollResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ScrollRequest> {
        @Nullable
        private Time scroll;
        private String scrollId;

        public final Builder scroll(@Nullable Time value) {
            this.scroll = value;
            return this;
        }

        public final Builder scroll(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.scroll(fn.apply(new Time.Builder()).build());
        }

        public final Builder scrollId(String value) {
            this.scrollId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScrollRequest build() {
            this._checkSingleUse();
            return new ScrollRequest(this);
        }
    }
}

