/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoAction;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoBootstrap;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoClient;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoDiscover;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoPath;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoRepositories;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoScript;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSearch;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsCluster;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsHttp;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsIngest;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsNetwork;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsNode;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsTransport;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoXpack;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeInfoSettings
implements JsonpSerializable {
    private final NodeInfoSettingsCluster cluster;
    private final NodeInfoSettingsNode node;
    private final NodeInfoPath path;
    @Nullable
    private final NodeInfoRepositories repositories;
    @Nullable
    private final NodeInfoDiscover discovery;
    @Nullable
    private final NodeInfoAction action;
    private final NodeInfoClient client;
    private final NodeInfoSettingsHttp http;
    @Nullable
    private final NodeInfoBootstrap bootstrap;
    private final NodeInfoSettingsTransport transport;
    @Nullable
    private final NodeInfoSettingsNetwork network;
    @Nullable
    private final NodeInfoXpack xpack;
    @Nullable
    private final NodeInfoScript script;
    @Nullable
    private final NodeInfoSearch search;
    @Nullable
    private final NodeInfoSettingsIngest ingest;
    public static final JsonpDeserializer<NodeInfoSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSettings::setupNodeInfoSettingsDeserializer);

    private NodeInfoSettings(Builder builder) {
        this.cluster = ApiTypeHelper.requireNonNull(builder.cluster, this, "cluster");
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.path = ApiTypeHelper.requireNonNull(builder.path, this, "path");
        this.repositories = builder.repositories;
        this.discovery = builder.discovery;
        this.action = builder.action;
        this.client = ApiTypeHelper.requireNonNull(builder.client, this, "client");
        this.http = ApiTypeHelper.requireNonNull(builder.http, this, "http");
        this.bootstrap = builder.bootstrap;
        this.transport = ApiTypeHelper.requireNonNull(builder.transport, this, "transport");
        this.network = builder.network;
        this.xpack = builder.xpack;
        this.script = builder.script;
        this.search = builder.search;
        this.ingest = builder.ingest;
    }

    public static NodeInfoSettings of(Function<Builder, ObjectBuilder<NodeInfoSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final NodeInfoSettingsCluster cluster() {
        return this.cluster;
    }

    public final NodeInfoSettingsNode node() {
        return this.node;
    }

    public final NodeInfoPath path() {
        return this.path;
    }

    @Nullable
    public final NodeInfoRepositories repositories() {
        return this.repositories;
    }

    @Nullable
    public final NodeInfoDiscover discovery() {
        return this.discovery;
    }

    @Nullable
    public final NodeInfoAction action() {
        return this.action;
    }

    public final NodeInfoClient client() {
        return this.client;
    }

    public final NodeInfoSettingsHttp http() {
        return this.http;
    }

    @Nullable
    public final NodeInfoBootstrap bootstrap() {
        return this.bootstrap;
    }

    public final NodeInfoSettingsTransport transport() {
        return this.transport;
    }

    @Nullable
    public final NodeInfoSettingsNetwork network() {
        return this.network;
    }

    @Nullable
    public final NodeInfoXpack xpack() {
        return this.xpack;
    }

    @Nullable
    public final NodeInfoScript script() {
        return this.script;
    }

    @Nullable
    public final NodeInfoSearch search() {
        return this.search;
    }

    @Nullable
    public final NodeInfoSettingsIngest ingest() {
        return this.ingest;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster");
        this.cluster.serialize(generator, mapper);
        generator.writeKey("node");
        this.node.serialize(generator, mapper);
        generator.writeKey("path");
        this.path.serialize(generator, mapper);
        if (this.repositories != null) {
            generator.writeKey("repositories");
            this.repositories.serialize(generator, mapper);
        }
        if (this.discovery != null) {
            generator.writeKey("discovery");
            this.discovery.serialize(generator, mapper);
        }
        if (this.action != null) {
            generator.writeKey("action");
            this.action.serialize(generator, mapper);
        }
        generator.writeKey("client");
        this.client.serialize(generator, mapper);
        generator.writeKey("http");
        this.http.serialize(generator, mapper);
        if (this.bootstrap != null) {
            generator.writeKey("bootstrap");
            this.bootstrap.serialize(generator, mapper);
        }
        generator.writeKey("transport");
        this.transport.serialize(generator, mapper);
        if (this.network != null) {
            generator.writeKey("network");
            this.network.serialize(generator, mapper);
        }
        if (this.xpack != null) {
            generator.writeKey("xpack");
            this.xpack.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.search != null) {
            generator.writeKey("search");
            this.search.serialize(generator, mapper);
        }
        if (this.ingest != null) {
            generator.writeKey("ingest");
            this.ingest.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeInfoSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cluster, NodeInfoSettingsCluster._DESERIALIZER, "cluster");
        op.add(Builder::node, NodeInfoSettingsNode._DESERIALIZER, "node");
        op.add(Builder::path, NodeInfoPath._DESERIALIZER, "path");
        op.add(Builder::repositories, NodeInfoRepositories._DESERIALIZER, "repositories");
        op.add(Builder::discovery, NodeInfoDiscover._DESERIALIZER, "discovery");
        op.add(Builder::action, NodeInfoAction._DESERIALIZER, "action");
        op.add(Builder::client, NodeInfoClient._DESERIALIZER, "client");
        op.add(Builder::http, NodeInfoSettingsHttp._DESERIALIZER, "http");
        op.add(Builder::bootstrap, NodeInfoBootstrap._DESERIALIZER, "bootstrap");
        op.add(Builder::transport, NodeInfoSettingsTransport._DESERIALIZER, "transport");
        op.add(Builder::network, NodeInfoSettingsNetwork._DESERIALIZER, "network");
        op.add(Builder::xpack, NodeInfoXpack._DESERIALIZER, "xpack");
        op.add(Builder::script, NodeInfoScript._DESERIALIZER, "script");
        op.add(Builder::search, NodeInfoSearch._DESERIALIZER, "search");
        op.add(Builder::ingest, NodeInfoSettingsIngest._DESERIALIZER, "ingest");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeInfoSettings> {
        private NodeInfoSettingsCluster cluster;
        private NodeInfoSettingsNode node;
        private NodeInfoPath path;
        @Nullable
        private NodeInfoRepositories repositories;
        @Nullable
        private NodeInfoDiscover discovery;
        @Nullable
        private NodeInfoAction action;
        private NodeInfoClient client;
        private NodeInfoSettingsHttp http;
        @Nullable
        private NodeInfoBootstrap bootstrap;
        private NodeInfoSettingsTransport transport;
        @Nullable
        private NodeInfoSettingsNetwork network;
        @Nullable
        private NodeInfoXpack xpack;
        @Nullable
        private NodeInfoScript script;
        @Nullable
        private NodeInfoSearch search;
        @Nullable
        private NodeInfoSettingsIngest ingest;

        public final Builder cluster(NodeInfoSettingsCluster value) {
            this.cluster = value;
            return this;
        }

        public final Builder cluster(Function<NodeInfoSettingsCluster.Builder, ObjectBuilder<NodeInfoSettingsCluster>> fn) {
            return this.cluster(fn.apply(new NodeInfoSettingsCluster.Builder()).build());
        }

        public final Builder node(NodeInfoSettingsNode value) {
            this.node = value;
            return this;
        }

        public final Builder node(Function<NodeInfoSettingsNode.Builder, ObjectBuilder<NodeInfoSettingsNode>> fn) {
            return this.node(fn.apply(new NodeInfoSettingsNode.Builder()).build());
        }

        public final Builder path(NodeInfoPath value) {
            this.path = value;
            return this;
        }

        public final Builder path(Function<NodeInfoPath.Builder, ObjectBuilder<NodeInfoPath>> fn) {
            return this.path(fn.apply(new NodeInfoPath.Builder()).build());
        }

        public final Builder repositories(@Nullable NodeInfoRepositories value) {
            this.repositories = value;
            return this;
        }

        public final Builder repositories(Function<NodeInfoRepositories.Builder, ObjectBuilder<NodeInfoRepositories>> fn) {
            return this.repositories(fn.apply(new NodeInfoRepositories.Builder()).build());
        }

        public final Builder discovery(@Nullable NodeInfoDiscover value) {
            this.discovery = value;
            return this;
        }

        public final Builder discovery(Function<NodeInfoDiscover.Builder, ObjectBuilder<NodeInfoDiscover>> fn) {
            return this.discovery(fn.apply(new NodeInfoDiscover.Builder()).build());
        }

        public final Builder action(@Nullable NodeInfoAction value) {
            this.action = value;
            return this;
        }

        public final Builder action(Function<NodeInfoAction.Builder, ObjectBuilder<NodeInfoAction>> fn) {
            return this.action(fn.apply(new NodeInfoAction.Builder()).build());
        }

        public final Builder client(NodeInfoClient value) {
            this.client = value;
            return this;
        }

        public final Builder client(Function<NodeInfoClient.Builder, ObjectBuilder<NodeInfoClient>> fn) {
            return this.client(fn.apply(new NodeInfoClient.Builder()).build());
        }

        public final Builder http(NodeInfoSettingsHttp value) {
            this.http = value;
            return this;
        }

        public final Builder http(Function<NodeInfoSettingsHttp.Builder, ObjectBuilder<NodeInfoSettingsHttp>> fn) {
            return this.http(fn.apply(new NodeInfoSettingsHttp.Builder()).build());
        }

        public final Builder bootstrap(@Nullable NodeInfoBootstrap value) {
            this.bootstrap = value;
            return this;
        }

        public final Builder bootstrap(Function<NodeInfoBootstrap.Builder, ObjectBuilder<NodeInfoBootstrap>> fn) {
            return this.bootstrap(fn.apply(new NodeInfoBootstrap.Builder()).build());
        }

        public final Builder transport(NodeInfoSettingsTransport value) {
            this.transport = value;
            return this;
        }

        public final Builder transport(Function<NodeInfoSettingsTransport.Builder, ObjectBuilder<NodeInfoSettingsTransport>> fn) {
            return this.transport(fn.apply(new NodeInfoSettingsTransport.Builder()).build());
        }

        public final Builder network(@Nullable NodeInfoSettingsNetwork value) {
            this.network = value;
            return this;
        }

        public final Builder network(Function<NodeInfoSettingsNetwork.Builder, ObjectBuilder<NodeInfoSettingsNetwork>> fn) {
            return this.network(fn.apply(new NodeInfoSettingsNetwork.Builder()).build());
        }

        public final Builder xpack(@Nullable NodeInfoXpack value) {
            this.xpack = value;
            return this;
        }

        public final Builder xpack(Function<NodeInfoXpack.Builder, ObjectBuilder<NodeInfoXpack>> fn) {
            return this.xpack(fn.apply(new NodeInfoXpack.Builder()).build());
        }

        public final Builder script(@Nullable NodeInfoScript value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<NodeInfoScript.Builder, ObjectBuilder<NodeInfoScript>> fn) {
            return this.script(fn.apply(new NodeInfoScript.Builder()).build());
        }

        public final Builder search(@Nullable NodeInfoSearch value) {
            this.search = value;
            return this;
        }

        public final Builder search(Function<NodeInfoSearch.Builder, ObjectBuilder<NodeInfoSearch>> fn) {
            return this.search(fn.apply(new NodeInfoSearch.Builder()).build());
        }

        public final Builder ingest(@Nullable NodeInfoSettingsIngest value) {
            this.ingest = value;
            return this;
        }

        public final Builder ingest(Function<NodeInfoSettingsIngest.Builder, ObjectBuilder<NodeInfoSettingsIngest>> fn) {
            return this.ingest(fn.apply(new NodeInfoSettingsIngest.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeInfoSettings build() {
            this._checkSingleUse();
            return new NodeInfoSettings(this);
        }
    }
}

