/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_ruleset;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.query_ruleset.PutResponse;
import co.elastic.clients.elasticsearch.query_ruleset.QueryRuleset;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class PutRequest
extends RequestBase
implements JsonpSerializable {
    private final String rulesetId;
    private final QueryRuleset queryRuleset;
    public static final JsonpDeserializer<PutRequest> _DESERIALIZER = PutRequest.createPutRequestDeserializer();
    public static final Endpoint<PutRequest, PutResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutRequest, PutResponse>("es/query_ruleset.put", request -> "PUT", request -> {
        boolean _rulesetId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_query_rules");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.rulesetId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _rulesetId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("rulesetId", request.rulesetId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutResponse._DESERIALIZER);

    private PutRequest(Builder builder) {
        this.rulesetId = ApiTypeHelper.requireNonNull(builder.rulesetId, this, "rulesetId");
        this.queryRuleset = ApiTypeHelper.requireNonNull(builder.queryRuleset, this, "queryRuleset");
    }

    public static PutRequest of(Function<Builder, ObjectBuilder<PutRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String rulesetId() {
        return this.rulesetId;
    }

    public final QueryRuleset queryRuleset() {
        return this.queryRuleset;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.queryRuleset.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<PutRequest> createPutRequestDeserializer() {
        JsonpDeserializer<QueryRuleset> valueDeserializer = QueryRuleset._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().queryRuleset((QueryRuleset)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutRequest> {
        private String rulesetId;
        private QueryRuleset queryRuleset;

        public final Builder rulesetId(String value) {
            this.rulesetId = value;
            return this;
        }

        public final Builder queryRuleset(QueryRuleset value) {
            this.queryRuleset = value;
            return this;
        }

        public final Builder queryRuleset(Function<QueryRuleset.Builder, ObjectBuilder<QueryRuleset>> fn) {
            return this.queryRuleset(fn.apply(new QueryRuleset.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            QueryRuleset value = QueryRuleset._DESERIALIZER.deserialize(parser, mapper);
            return this.queryRuleset(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutRequest build() {
            this._checkSingleUse();
            return new PutRequest(this);
        }
    }
}

