/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_ruleset.list;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class QueryRulesetListItem
implements JsonpSerializable {
    private final String rulesetId;
    private final int rulesCount;
    public static final JsonpDeserializer<QueryRulesetListItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRulesetListItem::setupQueryRulesetListItemDeserializer);

    private QueryRulesetListItem(Builder builder) {
        this.rulesetId = ApiTypeHelper.requireNonNull(builder.rulesetId, this, "rulesetId");
        this.rulesCount = ApiTypeHelper.requireNonNull(builder.rulesCount, this, "rulesCount");
    }

    public static QueryRulesetListItem of(Function<Builder, ObjectBuilder<QueryRulesetListItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String rulesetId() {
        return this.rulesetId;
    }

    public final int rulesCount() {
        return this.rulesCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("ruleset_id");
        generator.write(this.rulesetId);
        generator.writeKey("rules_count");
        generator.write(this.rulesCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupQueryRulesetListItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rulesetId, JsonpDeserializer.stringDeserializer(), "ruleset_id");
        op.add(Builder::rulesCount, JsonpDeserializer.integerDeserializer(), "rules_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryRulesetListItem> {
        private String rulesetId;
        private Integer rulesCount;

        public final Builder rulesetId(String value) {
            this.rulesetId = value;
            return this;
        }

        public final Builder rulesCount(int value) {
            this.rulesCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRulesetListItem build() {
            this._checkSingleUse();
            return new QueryRulesetListItem(this);
        }
    }
}

