/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.graph;

import com.alibaba.cloud.ai.autoconfigure.graph.GraphObservationProperties;
import com.alibaba.cloud.ai.graph.CompileConfig;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.observation.GraphObservationLifecycleListener;
import com.alibaba.cloud.ai.graph.observation.edge.GraphEdgeObservationHandler;
import com.alibaba.cloud.ai.graph.observation.graph.GraphObservationHandler;
import com.alibaba.cloud.ai.graph.observation.node.GraphNodeObservationHandler;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@ConditionalOnClass(value={StateGraph.class, ObservationRegistry.class})
@EnableConfigurationProperties(value={GraphObservationProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.graph.observation", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class GraphObservationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GraphObservationLifecycleListener graphObservationLifecycleListener(ObjectProvider<ObservationRegistry> observationRegistry) {
        return new GraphObservationLifecycleListener((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
    }

    @Bean
    @ConditionalOnMissingBean
    public CompileConfig observationGraphCompileConfig(ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<GraphObservationLifecycleListener> graphObservationLifecycleListeners) {
        CompileConfig.Builder builder = CompileConfig.builder().observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        graphObservationLifecycleListeners.ifUnique(arg_0 -> ((CompileConfig.Builder)builder).withLifecycleListener(arg_0));
        return builder.build();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MeterRegistry.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    static class ObservationHandlersConfiguration {
        ObservationHandlersConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public GraphObservationHandler graphObservationHandler(MeterRegistry meterRegistry) {
            return new GraphObservationHandler(meterRegistry);
        }

        @Bean
        @ConditionalOnMissingBean
        public GraphNodeObservationHandler graphNodeObservationHandler(MeterRegistry meterRegistry) {
            return new GraphNodeObservationHandler(meterRegistry);
        }

        @Bean
        @ConditionalOnMissingBean
        public GraphEdgeObservationHandler graphEdgeObservationHandler(MeterRegistry meterRegistry) {
            return new GraphEdgeObservationHandler(meterRegistry);
        }
    }
}

