/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.jinacrawler;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallUtils;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.jinacrawler.JinaCrawlerProperties;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JinaCrawlerService
implements Function<Request, Response> {
    private static final Logger log = LoggerFactory.getLogger(JinaCrawlerService.class);
    private final JsonParseTool jsonParseTool;
    private final WebClientTool webClientTool;
    private final JinaCrawlerProperties properties;

    public JinaCrawlerService(JsonParseTool jsonParseTool, WebClientTool webClientTool, JinaCrawlerProperties properties) {
        this.jsonParseTool = jsonParseTool;
        this.webClientTool = webClientTool;
        this.properties = properties;
    }

    @Override
    public Response apply(Request request) {
        if (!CommonToolCallUtils.isValidUrl((String)request.url())) {
            throw new RuntimeException("Invalid url: " + request.url());
        }
        if (!StringUtils.hasText((String)this.properties.getApiKey())) {
            throw new RuntimeException("Please set api key");
        }
        String responseStr = "";
        try {
            responseStr = (String)this.webClientTool.post("/", (Object)request).block();
            return new Response(this.jsonParseTool.jsonToMap(responseStr, Object.class), (String)this.jsonParseTool.getDepthFieldValue(responseStr, (TypeReference)new TypeReference<String>(){}, new String[]{"data", "content"}));
        }
        catch (Exception e) {
            log.error("Jina reader request failed: ", (Throwable)e);
            if (e instanceof JsonProcessingException && StringUtils.hasText((String)responseStr)) {
                return new Response(Map.of("data", responseStr), null);
            }
            throw new RuntimeException(e);
        }
    }

    @JsonClassDescription(value="get response from Jina Reader API")
    public record Request(@JsonPropertyDescription(value="url") String url) {
    }

    @JsonClassDescription(value="Jina Reader API result")
    public record Response(@JsonPropertyDescription(value="Jina Response Json Object") Map<String, Object> json, @JsonPropertyDescription(value="Reader result from url") String content) {
    }
}

