/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.gateway;

import com.alibaba.cloud.sentinel.datasource.converter.JsonConverter;
import com.alibaba.cloud.sentinel.datasource.converter.XmlConverter;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiPathPredicateItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiPredicateGroupItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiPredicateItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.sentinel.enabled"}, matchIfMissing=true)
public class SentinelGatewayAutoConfiguration {

    @ConditionalOnClass(value={ObjectMapper.class})
    @Configuration(proxyBeanMethods=false)
    protected static class SentinelConverterConfiguration {
        protected SentinelConverterConfiguration() {
        }

        @ConditionalOnClass(value={XmlMapper.class})
        @Configuration(proxyBeanMethods=false)
        protected static class SentinelXmlConfiguration {
            private XmlMapper xmlMapper = new XmlMapper();

            public SentinelXmlConfiguration() {
                this.xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                ApiPredicateItemDeserializer deserializer = new ApiPredicateItemDeserializer();
                deserializer.registerApiPredicateItem("pattern", ApiPathPredicateItem.class);
                deserializer.registerApiPredicateItem("items", ApiPredicateGroupItem.class);
                SimpleModule module = new SimpleModule("PolymorphicGatewayDeserializerModule", new Version(1, 0, 0, null, null, null));
                module.addDeserializer(ApiPredicateItem.class, (JsonDeserializer)deserializer);
                this.xmlMapper.registerModule((Module)module);
            }

            @Bean(value={"sentinel-xml-gw-flow-converter"})
            public XmlConverter xmlGatewayFlowConverter() {
                return new XmlConverter(this.xmlMapper, GatewayFlowRule.class);
            }

            @Bean(value={"sentinel-xml-gw-api-group-converter"})
            public XmlConverter xmlApiConverter() {
                return new XmlConverter(this.xmlMapper, ApiDefinition.class);
            }
        }

        @Configuration(proxyBeanMethods=false)
        protected static class SentinelJsonConfiguration {
            private ObjectMapper objectMapper = new ObjectMapper();

            public SentinelJsonConfiguration() {
                this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                ApiPredicateItemDeserializer deserializer = new ApiPredicateItemDeserializer();
                deserializer.registerApiPredicateItem("pattern", ApiPathPredicateItem.class);
                deserializer.registerApiPredicateItem("items", ApiPredicateGroupItem.class);
                SimpleModule module = new SimpleModule("PolymorphicApiPredicateItemDeserializerModule", new Version(1, 0, 0, null, null, null));
                module.addDeserializer(ApiPredicateItem.class, (JsonDeserializer)deserializer);
                this.objectMapper.registerModule((Module)module);
            }

            @Bean(value={"sentinel-json-gw-flow-converter"})
            public JsonConverter jsonGatewayFlowConverter() {
                return new JsonConverter(this.objectMapper, GatewayFlowRule.class);
            }

            @Bean(value={"sentinel-json-gw-api-group-converter"})
            public JsonConverter jsonApiConverter() {
                return new JsonConverter(this.objectMapper, ApiDefinition.class);
            }
        }

        static class ApiPredicateItemDeserializer
        extends StdDeserializer<ApiPredicateItem> {
            private Map<String, Class<? extends ApiPredicateItem>> registry = new HashMap<String, Class<? extends ApiPredicateItem>>();

            ApiPredicateItemDeserializer() {
                super(ApiPredicateItem.class);
            }

            void registerApiPredicateItem(String uniqueAttribute, Class<? extends ApiPredicateItem> apiPredicateItemClass) {
                this.registry.put(uniqueAttribute, apiPredicateItemClass);
            }

            public ApiPredicateItem deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                ObjectMapper mapper = (ObjectMapper)jp.getCodec();
                ObjectNode root = (ObjectNode)mapper.readTree(jp);
                Class<? extends ApiPredicateItem> apiPredicateItemClass = null;
                Iterator elementsIterator = root.fields();
                while (elementsIterator.hasNext()) {
                    Map.Entry element = (Map.Entry)elementsIterator.next();
                    String name = (String)element.getKey();
                    if (!this.registry.containsKey(name)) continue;
                    apiPredicateItemClass = this.registry.get(name);
                    break;
                }
                if (apiPredicateItemClass == null) {
                    return null;
                }
                return (ApiPredicateItem)mapper.readValue(root.toString(), apiPredicateItemClass);
            }
        }
    }
}

