/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.custom;

import com.alibaba.cloud.sentinel.SentinelProperties;
import com.alibaba.cloud.sentinel.custom.SentinelBeanPostProcessor;
import com.alibaba.cloud.sentinel.custom.SentinelDataSourceHandler;
import com.alibaba.cloud.sentinel.datasource.converter.JsonConverter;
import com.alibaba.cloud.sentinel.datasource.converter.XmlConverter;
import com.alibaba.csp.sentinel.annotation.aspectj.SentinelResourceAspect;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.sentinel.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SentinelProperties.class})
public class SentinelAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SentinelResourceAspect sentinelResourceAspect() {
        return new SentinelResourceAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    @ConditionalOnProperty(name={"resttemplate.sentinel.enabled"}, havingValue="true", matchIfMissing=true)
    public static SentinelBeanPostProcessor sentinelBeanPostProcessor(ApplicationContext applicationContext) {
        return new SentinelBeanPostProcessor(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public SentinelDataSourceHandler sentinelDataSourceHandler(DefaultListableBeanFactory beanFactory, SentinelProperties sentinelProperties, Environment env) {
        return new SentinelDataSourceHandler(beanFactory, sentinelProperties, env);
    }

    @ConditionalOnClass(value={ObjectMapper.class})
    @Configuration(proxyBeanMethods=false)
    protected static class SentinelConverterConfiguration {
        protected SentinelConverterConfiguration() {
        }

        @ConditionalOnClass(value={XmlMapper.class})
        @Configuration(proxyBeanMethods=false)
        protected static class SentinelXmlConfiguration {
            private XmlMapper xmlMapper = new XmlMapper();

            public SentinelXmlConfiguration() {
                this.xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            }

            @Bean(value={"sentinel-xml-flow-converter"})
            public XmlConverter xmlFlowConverter() {
                return new XmlConverter(this.xmlMapper, FlowRule.class);
            }

            @Bean(value={"sentinel-xml-degrade-converter"})
            public XmlConverter xmlDegradeConverter() {
                return new XmlConverter(this.xmlMapper, DegradeRule.class);
            }

            @Bean(value={"sentinel-xml-system-converter"})
            public XmlConverter xmlSystemConverter() {
                return new XmlConverter(this.xmlMapper, SystemRule.class);
            }

            @Bean(value={"sentinel-xml-authority-converter"})
            public XmlConverter xmlAuthorityConverter() {
                return new XmlConverter(this.xmlMapper, AuthorityRule.class);
            }

            @Bean(value={"sentinel-xml-param-flow-converter"})
            public XmlConverter xmlParamFlowConverter() {
                return new XmlConverter(this.xmlMapper, ParamFlowRule.class);
            }
        }

        @Configuration(proxyBeanMethods=false)
        protected static class SentinelJsonConfiguration {
            private ObjectMapper objectMapper = new ObjectMapper();

            public SentinelJsonConfiguration() {
                this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            }

            @Bean(value={"sentinel-json-flow-converter"})
            public JsonConverter jsonFlowConverter() {
                return new JsonConverter(this.objectMapper, FlowRule.class);
            }

            @Bean(value={"sentinel-json-degrade-converter"})
            public JsonConverter jsonDegradeConverter() {
                return new JsonConverter(this.objectMapper, DegradeRule.class);
            }

            @Bean(value={"sentinel-json-system-converter"})
            public JsonConverter jsonSystemConverter() {
                return new JsonConverter(this.objectMapper, SystemRule.class);
            }

            @Bean(value={"sentinel-json-authority-converter"})
            public JsonConverter jsonAuthorityConverter() {
                return new JsonConverter(this.objectMapper, AuthorityRule.class);
            }

            @Bean(value={"sentinel-json-param-flow-converter"})
            public JsonConverter jsonParamFlowConverter() {
                return new JsonConverter(this.objectMapper, ParamFlowRule.class);
            }
        }
    }
}

