/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.tools;

import com.alibaba.dashscope.common.TypeRegistry;
import com.alibaba.dashscope.tools.T2Image.Text2Image;
import com.alibaba.dashscope.tools.ToolFunction;
import com.alibaba.dashscope.tools.ToolInterface;
import com.alibaba.dashscope.tools.codeinterpretertool.ToolCodeInterpreter;
import com.alibaba.dashscope.tools.search.ToolQuarkSearch;
import com.alibaba.dashscope.tools.wanx.ToolWanX;

public abstract class ToolBase
implements ToolInterface {
    private static final TypeRegistry<ToolBase> toolRegistry = new TypeRegistry();

    protected static synchronized void registerTool(String toolType, Class<? extends ToolBase> clazz) {
        toolRegistry.register(toolType, clazz);
    }

    public static synchronized Class<? extends ToolBase> getToolClass(String toolType) {
        return toolRegistry.get(toolType);
    }

    @Override
    public abstract String getType();

    protected ToolBase(ToolBaseBuilder<?, ?> b) {
    }

    static {
        ToolBase.registerTool("function", ToolFunction.class);
        ToolBase.registerTool("quark_search", ToolQuarkSearch.class);
        ToolBase.registerTool("code_interpreter", ToolCodeInterpreter.class);
        ToolBase.registerTool("wanx", ToolWanX.class);
        ToolBase.registerTool("text_to_image", Text2Image.class);
    }

    public static abstract class ToolBaseBuilder<C extends ToolBase, B extends ToolBaseBuilder<C, B>> {
        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ToolBase.ToolBaseBuilder()";
        }
    }
}

