/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config;

import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.registry.support.AbstractRegistryFactory;
import com.alibaba.dubbo.rpc.Protocol;
import java.util.concurrent.atomic.AtomicBoolean;

public class DubboShutdownHook
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(DubboShutdownHook.class);
    private static final DubboShutdownHook dubboShutdownHook = new DubboShutdownHook("DubboShutdownHook");
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    public static DubboShutdownHook getDubboShutdownHook() {
        return dubboShutdownHook;
    }

    private DubboShutdownHook(String name) {
        super(name);
    }

    @Override
    public void run() {
        if (logger.isInfoEnabled()) {
            logger.info("Run shutdown hook now.");
        }
        this.destroyAll();
    }

    public void destroyAll() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        AbstractRegistryFactory.destroyAll();
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(Protocol.class);
        for (String protocolName : loader.getLoadedExtensions()) {
            try {
                Protocol protocol = (Protocol)loader.getLoadedExtension(protocolName);
                if (protocol == null) continue;
                protocol.destroy();
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
        }
    }
}

