/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.lightapi;

import com.alibaba.dubbo.rpc.service.GenericService;
import com.taobao.hsf.app.spring.util.HSFSpringConsumerBean;
import com.taobao.hsf.lightapi.ServiceFactory;
import com.taobao.hsf.lightapi.util.AsynType;
import com.taobao.hsf.lightapi.util.GenericMethod;
import com.taobao.hsf.lightapi.util.LightConstant;
import com.taobao.hsf.lightapi.util.Partner;
import com.taobao.hsf.model.metadata.MethodSpecial;
import com.taobao.hsf.standalone.HSFStarter;
import com.taobao.hsf.standalone.util.Constant;
import com.taobao.hsf.tbremoting.invoke.HSFResponseCallback;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ConsumerService {
    private HSFSpringConsumerBean consumer;
    private AtomicReference<MockProxy> mockProxy = new AtomicReference<Object>(null);
    private AtomicBoolean inited = new AtomicBoolean(false);
    private AtomicBoolean consumed = new AtomicBoolean(false);
    private List<MethodSpecial> methodSpecials = new LinkedList<MethodSpecial>();
    private Map<String, AsynType> asynMethods = new ConcurrentHashMap<String, AsynType>();
    private ConcurrentHashMap<Method, Object> mockContext = new ConcurrentHashMap();
    private AtomicBoolean mockAll = new AtomicBoolean(false);
    private String serviceInterface;
    private String version = "1.0.0";
    private String uniqueName;
    private GenericService genericService;

    public ConsumerService newConsumer() {
        if (this.inited.compareAndSet(false, true)) {
            Class<?> consumerClazz;
            Class<?> clazz = consumerClazz = LightConstant.pandoraInited != false ? this.initConsumerClass() : HSFStarter.getHSFSpringConsumerBean();
            if (consumerClazz != null) {
                try {
                    this.consumer = (HSFSpringConsumerBean)consumerClazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(LightConstant.INIT_C_FAIL, e);
                }
            } else {
                throw new RuntimeException(LightConstant.INIT_C_FAIL + "because there is no HSFSpringConsumerBean's Class found.");
            }
            return this;
        }
        throw new RuntimeException(LightConstant.MULTI_INIT);
    }

    public ConsumerService service(String service) {
        this.checkInited();
        this.consumer.setInterfaceName(service);
        this.serviceInterface = service;
        return this;
    }

    public ConsumerService version(String version) {
        this.checkInited();
        this.consumer.setVersion(version);
        this.version = version;
        return this;
    }

    public ConsumerService group(String group) {
        this.checkInited();
        this.consumer.setGroup(group);
        return this;
    }

    public ConsumerService generic() {
        this.checkInited();
        this.consumer.setGeneric("true");
        return this;
    }

    public Object genericInvoke(GenericMethod method) throws Exception {
        this.checkInited();
        if (this.genericService == null) {
            this.consumer.setGeneric("true");
            this.genericService = (GenericService)this.consumer.getObject();
        }
        return this.genericService.$invoke(method.getMethodName(), method.getArgsType(), method.getArgsVal());
    }

    public ConsumerService timeout(int timeout) {
        this.checkInited();
        this.consumer.setClientTimeout(timeout);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerService methodTimeout(String methodName, int timeout) {
        this.checkInited();
        MethodSpecial ms = new MethodSpecial();
        ms.setMethodName(methodName);
        ms.setClientTimeout((long)timeout);
        List<MethodSpecial> list = this.methodSpecials;
        synchronized (list) {
            this.methodSpecials.add(ms);
        }
        return this;
    }

    public Object subscribe() {
        this.checkInited();
        try {
            if (this.consumed.compareAndSet(false, true)) {
                this.putMethodSpecials();
                this.putAsyncMethods();
                this.consumer.init();
                this.uniqueName = this.serviceInterface + ":" + this.version;
            }
            return this.consumer.getObject();
        }
        catch (Exception e) {
            throw new RuntimeException(LightConstant.CONS_FAIL, e);
        }
    }

    public Object getMockService() {
        Class clazz;
        this.checkInited();
        if (this.mockProxy.get() == null && (clazz = this.consumer.getObjectType()) != null) {
            this.mockProxy.compareAndSet(null, new MockProxy(new Class[]{clazz}));
        }
        return this.mockProxy.get().getProxyInstance();
    }

    public void mock(Method method, Object expectValue) {
        if (method == null) {
            return;
        }
        this.mockContext.put(method, expectValue);
    }

    public void mock(List<Method> methods, Object expectValue) {
        if (methods == null) {
            return;
        }
        for (Method method : methods) {
            this.mockContext.put(method, expectValue);
        }
    }

    public void cancelMock(Method method) {
        if (method == null) {
            return;
        }
        this.mockContext.remove(method);
    }

    public void cancelAllMock() {
        this.mockContext.clear();
    }

    public void cancelMock(List<Method> methods) {
        if (methods == null) {
            return;
        }
        for (Method method : methods) {
            this.mockContext.remove(method);
        }
    }

    private void putAsyncMethods() {
        this.checkInited();
        ArrayList<String> asynDesc = new ArrayList<String>();
        for (Map.Entry<String, AsynType> entry : this.asynMethods.entrySet()) {
            if (entry.getValue().getType().equals("future")) {
                asynDesc.add(MessageFormat.format("name:{0};type:{1}", entry.getKey(), entry.getValue().getType()));
                continue;
            }
            if (!entry.getValue().getType().equals("callback")) continue;
            asynDesc.add(MessageFormat.format("name:{0};type:{1};listener:{2}", entry.getKey(), entry.getValue().getType(), entry.getValue().getListenerClass()));
        }
        this.consumer.setAsyncallMethods(asynDesc);
    }

    public void sync() throws Exception {
        long beginTime = System.currentTimeMillis();
        while (this.addresses().size() <= 0 && System.currentTimeMillis() - beginTime <= 5000L) {
        }
    }

    public ConsumerService targetIp(String ip) throws Exception {
        this.checkInited();
        if (Constant.main_version != 1) {
            Partner.setRunModeToTest();
        }
        this.sync();
        this.validIp(this.addresses(), ip);
        this.consumer.setTarget(ip);
        return this;
    }

    public List<String> addresses() throws Exception {
        this.checkInited();
        return Partner.allAddresses(this.uniqueName);
    }

    public boolean isConsumed() {
        return this.consumed.get();
    }

    public ConsumerService futureMethod(String methodName) {
        this.checkInited();
        this.asynMethods.put(methodName, new AsynType("future"));
        return this;
    }

    public ConsumerService callbackMethod(String methodName, Object listener) {
        this.checkInited();
        if (!HSFResponseCallback.class.isAssignableFrom(listener.getClass())) {
            throw new RuntimeException("The callback listener : " + listener + ",doesn't implements HSFResponseCallback interface.");
        }
        this.asynMethods.put(methodName, new AsynType("callback", listener.getClass()));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putMethodSpecials() {
        List<MethodSpecial> list = this.methodSpecials;
        synchronized (list) {
            if (this.methodSpecials.size() > 0) {
                MethodSpecial[] specials = new MethodSpecial[this.methodSpecials.size()];
                for (int i = 0; i < this.methodSpecials.size(); ++i) {
                    specials[i] = this.methodSpecials.get(i);
                }
                this.consumer.setMethodSpecials(specials);
            }
        }
    }

    private void checkInited() {
        if (this.inited.compareAndSet(true, true)) {
            return;
        }
        throw new RuntimeException(LightConstant.NOT_INIT_BEAN);
    }

    private void validIp(List<String> addresses, String ip) {
        for (String address : addresses) {
            if (!address.startsWith(ip)) continue;
            return;
        }
        if (addresses == null || addresses.size() == 0) {
            throw new RuntimeException("There is no address for service you want to invoke.Maybe you invoke too fast or this service is not exist");
        }
        throw new RuntimeException(LightConstant.INVALID_IP);
    }

    private Class<?> initConsumerClass() {
        try {
            return Class.forName("com.taobao.hsf.app.spring.util.HSFSpringConsumerBean", false, ServiceFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(LightConstant.INIT_C_FAIL, e);
        }
    }

    public class MockProxy
    implements InvocationHandler {
        private Object proxyInstance;
        private String proxyInterfaceName;
        private Method equalsMethod;
        private Method toStringMethod;
        private Method hashCodeMethod;

        public MockProxy(Class<?>[] classes) {
            this.proxyInstance = Proxy.newProxyInstance(MockProxy.class.getClassLoader(), classes, (InvocationHandler)this);
            this.proxyInterfaceName = classes[0].getName();
            try {
                Field hashCodeField = this.proxyInstance.getClass().getDeclaredField("m0");
                hashCodeField.setAccessible(true);
                this.hashCodeMethod = (Method)hashCodeField.get(this.proxyInstance);
                Field equalsField = this.proxyInstance.getClass().getDeclaredField("m1");
                equalsField.setAccessible(true);
                this.equalsMethod = (Method)equalsField.get(this.proxyInstance);
                Field toStringField = this.proxyInstance.getClass().getDeclaredField("m2");
                toStringField.setAccessible(true);
                this.toStringMethod = (Method)toStringField.get(this.proxyInstance);
            }
            catch (Exception e) {
                throw new RuntimeException(LightConstant.INIT_PROXY_FAIL, e);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method == this.toStringMethod) {
                return this.proxyInterfaceName;
            }
            if (method == this.equalsMethod) {
                return proxy == args[0];
            }
            if (method == this.hashCodeMethod) {
                return System.identityHashCode(proxy);
            }
            Object returnValue = ConsumerService.this.mockContext.get(method);
            if (returnValue != null) {
                return returnValue;
            }
            return method.invoke(ConsumerService.this.consumer.getObject(), args);
        }

        public Object getProxyInstance() {
            return this.proxyInstance;
        }
    }
}

