/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.lightapi;

import com.taobao.hsf.app.spring.util.HSFSpringProviderBean;
import com.taobao.hsf.lightapi.ServiceFactory;
import com.taobao.hsf.lightapi.util.LightConstant;
import com.taobao.hsf.lightapi.util.Partner;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.metadata.MethodSpecial;
import com.taobao.hsf.standalone.HSFStarter;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ProviderService {
    private HSFSpringProviderBean provider;
    private AtomicBoolean inited = new AtomicBoolean(false);
    private AtomicBoolean published = new AtomicBoolean(false);
    private List<MethodSpecial> methodSpecials = new LinkedList<MethodSpecial>();
    private String service;
    private String version = "1.0.0";

    public ProviderService newProvider() {
        if (this.inited.compareAndSet(false, true)) {
            Class<?> providerClazz;
            Class<?> clazz = providerClazz = LightConstant.pandoraInited != false ? this.initProviderClass() : HSFStarter.getHSFSpringProviderBean();
            if (providerClazz != null) {
                try {
                    this.provider = (HSFSpringProviderBean)providerClazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(LightConstant.INIT_P_FAIL, e);
                }
            } else {
                throw new RuntimeException(LightConstant.INIT_P_FAIL + "because there is no HSFSpringProviderBean Class found.");
            }
            return this;
        }
        throw new RuntimeException(LightConstant.MULTI_INIT);
    }

    public ProviderService service(String service) {
        this.checkInited();
        this.provider.setServiceInterface(service);
        this.service = service;
        return this;
    }

    public ProviderService version(String version) {
        this.checkInited();
        this.provider.setServiceVersion(version);
        this.version = version;
        return this;
    }

    public ProviderService group(String group) {
        this.checkInited();
        this.provider.setServiceGroup(group);
        return this;
    }

    public ProviderService impl(Object impl) {
        this.checkInited();
        this.provider.setTarget(impl);
        return this;
    }

    public ProviderService timeout(int timeout) {
        this.checkInited();
        this.provider.setClientTimeout(timeout);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderService methodTimeout(String methodName, int timeout) {
        this.checkInited();
        MethodSpecial ms = new MethodSpecial();
        ms.setMethodName(methodName);
        ms.setClientTimeout((long)timeout);
        List<MethodSpecial> list = this.methodSpecials;
        synchronized (list) {
            this.methodSpecials.add(ms);
        }
        return this;
    }

    public ProviderService supportAsynCall(boolean support) {
        this.checkInited();
        this.provider.setSupportAsynCall(support ? "true" : "false");
        return this;
    }

    public ProviderService clientTimeout(int clientTimeout) {
        this.checkInited();
        this.provider.setClientTimeout(clientTimeout);
        return this;
    }

    public void publish() {
        try {
            this.checkInited();
            this.putMethodSpecials();
            this.provider.init();
            this.published.compareAndSet(false, true);
        }
        catch (Exception e) {
            throw new RuntimeException(LightConstant.PUB_FAIL, e);
        }
    }

    public ProviderService serializeType(String serializeType) {
        this.checkInited();
        if (serializeType.equals("java") || serializeType.equals("hessian")) {
            this.provider.setSerializeType(serializeType);
        }
        this.provider.setPreferSerializeType(serializeType);
        return this;
    }

    public boolean isPublished() {
        String uniqueServiceName = this.service + ":" + this.version;
        return ApplicationModel.instance().getProvidedServiceModel(uniqueServiceName) != null;
    }

    public void offline() {
        this.checkInited();
        if (this.published.compareAndSet(true, false)) {
            this.provider.unregister();
        }
    }

    public void online() {
        this.checkInited();
        if (this.published.compareAndSet(false, true)) {
            this.provider.register();
        }
    }

    public boolean success() {
        return Partner.publishSuccess(this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putMethodSpecials() {
        List<MethodSpecial> list = this.methodSpecials;
        synchronized (list) {
            if (this.methodSpecials.size() > 0) {
                MethodSpecial[] specials = new MethodSpecial[this.methodSpecials.size()];
                for (int i = 0; i < this.methodSpecials.size(); ++i) {
                    specials[i] = this.methodSpecials.get(i);
                }
                this.provider.setMethodSpecials(specials);
            }
        }
    }

    private void checkInited() {
        if (!this.inited.compareAndSet(true, true)) {
            throw new RuntimeException(LightConstant.NOT_INIT_BEAN);
        }
    }

    private Class<?> initProviderClass() {
        try {
            return Class.forName("com.taobao.hsf.app.spring.util.HSFSpringProviderBean", false, ServiceFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(LightConstant.INIT_P_FAIL, e);
        }
    }
}

