/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.lightapi;

import com.taobao.hsf.lightapi.ConsumerService;
import com.taobao.hsf.lightapi.ProviderService;
import com.taobao.hsf.lightapi.util.LightConstant;
import com.taobao.hsf.standalone.HSFEasyStarter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceFactory {
    private static String sarPath = HSFEasyStarter.DEFAULT_RELEASE_PATH;
    private static String EMPTY = "";
    private static ConcurrentHashMap<String, String> systemProps = new ConcurrentHashMap();
    private static HashMap<String, ProviderService> providers = new HashMap();
    private static HashMap<String, ConsumerService> consumers = new HashMap();
    private static ServiceFactory factory;

    private ServiceFactory() {
        this(null);
    }

    private ServiceFactory(String id) {
        if (ServiceFactory.isPandoraInited()) {
            LightConstant.pandoraInited = true;
        } else {
            ServiceFactory.startPandora(id);
            LightConstant.pandoraInited = true;
        }
    }

    public List<ProviderService> providers() {
        return new ArrayList<ProviderService>(providers.values());
    }

    public List<ConsumerService> consumers() {
        return new ArrayList<ConsumerService>(consumers.values());
    }

    public synchronized ProviderService provider(String id) {
        if (providers.get(id) == null) {
            providers.put(id, new ProviderService().newProvider());
            return providers.get(id);
        }
        return providers.get(id);
    }

    public synchronized ConsumerService consumer(String id) {
        if (consumers.get(id) == null) {
            consumers.put(id, new ConsumerService().newConsumer());
            return consumers.get(id);
        }
        if (!consumers.get(id).isConsumed()) {
            throw new RuntimeException(LightConstant.NOT_CONS);
        }
        return consumers.get(id);
    }

    public synchronized void destroy(String id) {
        ProviderService provider = providers.get(id);
        if (provider != null) {
            provider.offline();
            this.clearProvider(id);
        }
    }

    public synchronized void clearConsumer(String id) {
        consumers.remove(id);
    }

    @Deprecated
    public synchronized void clearProvider(String id) {
        providers.remove(id);
    }

    public static synchronized ServiceFactory getInstance() {
        return ServiceFactory.getInstance(null);
    }

    public static synchronized ServiceFactory getInstanceWithPath(String path) {
        return ServiceFactory.getInstanceWithPathAndUniqueId(path, null);
    }

    public static synchronized ServiceFactory getInstanceWithPathAndUniqueId(String path, String uniqueId) {
        HSFEasyStarter.DEFAULT_RELEASE_PATH = path;
        sarPath = path;
        return ServiceFactory.getInstance(uniqueId);
    }

    private static synchronized ServiceFactory getInstance(String uniqueId) {
        if (factory == null) {
            factory = uniqueId == null ? new ServiceFactory() : new ServiceFactory(uniqueId);
        }
        return factory;
    }

    public static void addJVMProperty(String key, String value) {
        systemProps.put(key, value);
    }

    public static void addJVMProperty(Map<String, String> props) {
        systemProps.putAll(props);
    }

    private static boolean isPandoraInited() {
        Class<?> HSFClazz;
        try {
            HSFClazz = Class.forName("com.taobao.hsf.globalrule.GlobalRule", false, ServiceFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        if (HSFClazz != null) {
            String loader = HSFClazz.getClassLoader().getClass().getName().toLowerCase();
            return loader.contains("pandora");
        }
        return false;
    }

    private static void startPandora(String uniqueId) {
        ServiceFactory.addJVMProperties();
        if (uniqueId == null) {
            HSFEasyStarter.startFromPath(sarPath);
        } else {
            HSFEasyStarter.startWithPathAndIdentifier(EMPTY, uniqueId);
        }
    }

    private static void addJVMProperties() {
        for (Map.Entry<String, String> propEntry : systemProps.entrySet()) {
            System.setProperty(propEntry.getKey(), propEntry.getValue());
        }
    }

    static {
        System.out.println("LightApi is starting.");
    }
}

