/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.standalone;

import com.taobao.hsf.standalone.sar.HSFSarUtil;
import com.taobao.hsf.standalone.util.Constant;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;

public class HSFStarter {
    private static Map<String, Class<?>> exportedClassMap;

    public static void start(String sarPath) throws Exception {
        HSFStarter.start(sarPath, HSFStarter.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String sarPath, ClassLoader bizClassLoader) throws Exception {
        URL[] sarJars = HSFSarUtil.listSarJar(sarPath);
        if (sarJars == null || sarJars.length == 0) {
            throw new RuntimeException("Build jars from sar failed.Please delete the directory of taobao-hsf.sar and re-start.");
        }
        HSFStarter.decideVersion(sarJars);
        URLClassLoader hsfParentLoader = new URLClassLoader(sarJars, null){

            @Override
            public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                Class<?> clazz = null;
                clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
                if (name.contains("pandora")) {
                    try {
                        clazz = this.findClass(name);
                        if (clazz != null) {
                            if (resolve) {
                                this.resolveClass(clazz);
                            }
                            return clazz;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return super.loadClass(name, resolve);
            }
        };
        try {
            Thread.currentThread().setContextClassLoader(hsfParentLoader);
            Class<?> containerClass = Class.forName("com.taobao.hsf.container.HSFContainer", true, hsfParentLoader);
            Method startMethod = containerClass.getMethod("start", String[].class);
            startMethod.invoke(null, new Object[]{new String[]{sarPath}});
            Method setThirdContainerClassLoaderMethod = containerClass.getMethod("setThirdContainerClassLoader", ClassLoader.class);
            setThirdContainerClassLoaderMethod.invoke(null, bizClassLoader);
            Method getExportedClassesMethod = containerClass.getMethod("getExportedClasses", null);
            exportedClassMap = (Map)getExportedClassesMethod.invoke(null, (Object[])null);
            if (exportedClassMap.size() < 5) {
                System.out.println("hsfstarter.log:exportedClassMap.size() < 5 !");
            }
            ClassLoader osgiLoader = exportedClassMap.get("com.taobao.hsf.app.spring.util.HSFSpringConsumerBean").getClassLoader();
            Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, osgiLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(HSFStarter.class.getClassLoader());
        }
    }

    public static Class<?> getHSFSpringConsumerBean() {
        return exportedClassMap.get("com.taobao.hsf.app.spring.util.HSFSpringConsumerBean");
    }

    public static Class<?> getHSFSpringProviderBean() {
        return exportedClassMap.get("com.taobao.hsf.app.spring.util.HSFSpringProviderBean");
    }

    private static void decideVersion(URL[] sarJars) {
        for (URL url : sarJars) {
            if (!url.toString().contains("pandora")) continue;
            Constant.main_version = 2;
            return;
        }
    }
}

