/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.executor;

import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolManager.class);
    private Map<String, Map<String, Set<ExecutorService>>> resourcesManager;
    private static final ThreadPoolManager INSTANCE = new ThreadPoolManager();
    private static final AtomicBoolean CLOSED = new AtomicBoolean(false);

    public static ThreadPoolManager getInstance() {
        return INSTANCE;
    }

    private ThreadPoolManager() {
    }

    private void init() {
        this.resourcesManager = new ConcurrentHashMap<String, Map<String, Set<ExecutorService>>>(8);
    }

    public void register(String namespace, String group, ExecutorService executor) {
        this.resourcesManager.compute(namespace, (namespaceKey, map) -> {
            if (map == null) {
                map = new HashMap<String, Set>(8);
            }
            map.computeIfAbsent(group, groupKey -> new HashSet()).add(executor);
            return map;
        });
    }

    public void deregister(String namespace, String group) {
        this.resourcesManager.computeIfPresent(namespace, (key, map) -> {
            map.remove(group);
            return map;
        });
    }

    public void deregister(String namespace, String group, ExecutorService executor) {
        this.resourcesManager.computeIfPresent(namespace, (namespaceKey, map) -> {
            map.computeIfPresent(group, (groupKey, set) -> {
                set.remove(executor);
                return set;
            });
            return map;
        });
    }

    public void destroy(String namespace) {
        Map<String, Set<ExecutorService>> map = this.resourcesManager.remove(namespace);
        if (map != null) {
            for (Set<ExecutorService> set : map.values()) {
                for (ExecutorService executor : set) {
                    ThreadUtils.shutdownThreadPool(executor);
                }
                set.clear();
            }
            map.clear();
        }
    }

    public void destroy(String namespace, String group) {
        this.resourcesManager.computeIfPresent(namespace, (namespaceKey, map) -> {
            map.computeIfPresent(group, (groupKey, set) -> {
                for (ExecutorService executor : set) {
                    ThreadUtils.shutdownThreadPool(executor);
                }
                set.clear();
                return null;
            });
            return map;
        });
    }

    public static void shutdown() {
        if (!CLOSED.compareAndSet(false, true)) {
            return;
        }
        Set<String> namespaces = ThreadPoolManager.INSTANCE.resourcesManager.keySet();
        for (String namespace : namespaces) {
            INSTANCE.destroy(namespace);
        }
    }

    @JustForTest
    public Map<String, Map<String, Set<ExecutorService>>> getResourcesManager() {
        return this.resourcesManager;
    }

    static {
        INSTANCE.init();
        ThreadUtils.addShutdownHook(new Thread(() -> {
            LOGGER.warn("[ThreadPoolManager] Start destroying ThreadPool");
            ThreadPoolManager.shutdown();
            LOGGER.warn("[ThreadPoolManager] Destruction of the end");
        }));
    }
}

