/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.event;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstancesDiff {
    private final List<Instance> addedInstances = new ArrayList<Instance>();
    private final List<Instance> removedInstances = new ArrayList<Instance>();
    private final List<Instance> modifiedInstances = new ArrayList<Instance>();

    public InstancesDiff() {
    }

    public InstancesDiff(List<Instance> addedInstances, List<Instance> removedInstances, List<Instance> modifiedInstances) {
        this.setAddedInstances(addedInstances);
        this.setRemovedInstances(removedInstances);
        this.setModifiedInstances(modifiedInstances);
    }

    public List<Instance> getAddedInstances() {
        return this.addedInstances;
    }

    public void setAddedInstances(Collection<Instance> addedInstances) {
        this.addedInstances.clear();
        if (CollectionUtils.isNotEmpty(addedInstances)) {
            this.addedInstances.addAll(addedInstances);
        }
    }

    public List<Instance> getRemovedInstances() {
        return this.removedInstances;
    }

    public void setRemovedInstances(Collection<Instance> removedInstances) {
        this.removedInstances.clear();
        if (CollectionUtils.isNotEmpty(removedInstances)) {
            this.removedInstances.addAll(removedInstances);
        }
    }

    public List<Instance> getModifiedInstances() {
        return this.modifiedInstances;
    }

    public void setModifiedInstances(Collection<Instance> modifiedInstances) {
        this.modifiedInstances.clear();
        if (CollectionUtils.isNotEmpty(modifiedInstances)) {
            this.modifiedInstances.addAll(modifiedInstances);
        }
    }

    public boolean hasDifferent() {
        return this.isAdded() || this.isRemoved() || this.isModified();
    }

    public boolean isAdded() {
        return CollectionUtils.isNotEmpty(this.addedInstances);
    }

    public boolean isRemoved() {
        return CollectionUtils.isNotEmpty(this.removedInstances);
    }

    public boolean isModified() {
        return CollectionUtils.isNotEmpty(this.modifiedInstances);
    }
}

