/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.param;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Query {
    private boolean isEmpty = true;
    public static final Query EMPTY = Query.newInstance();
    private Map<String, Object> params = new LinkedHashMap<String, Object>();

    public static Query newInstance() {
        return new Query();
    }

    public Query addParam(String key, Object value) {
        this.isEmpty = false;
        this.params.put(key, value);
        return this;
    }

    public Object getValue(String key) {
        return this.params.get(key);
    }

    public void initParams(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.addParam(entry.getKey(), entry.getValue());
        }
    }

    public void initParams(List<String> list) {
        if ((list.size() & 1) != 0) {
            throw new IllegalArgumentException("list size must be a multiple of 2");
        }
        int i = 0;
        while (i < list.size()) {
            this.addParam(list.get(i++), list.get(i++));
        }
    }

    public String toQueryUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        Set<Map.Entry<String, Object>> entrySet = this.params.entrySet();
        int i = entrySet.size();
        for (Map.Entry<String, Object> entry : entrySet) {
            try {
                urlBuilder.append(entry.getKey()).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8"));
                if (i > 1) {
                    urlBuilder.append("&");
                }
                --i;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return urlBuilder.toString();
    }

    public void clear() {
        this.isEmpty = false;
        this.params.clear();
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }
}

