/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.Objects;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;

public class ExceptionUtil {
    public static String getAllExceptionMsg(Throwable e) {
        StringBuilder strBuilder = new StringBuilder();
        for (Throwable cause = e; cause != null && !StringUtils.isEmpty((CharSequence)cause.getMessage()); cause = cause.getCause()) {
            strBuilder.append("caused: ").append(cause.getMessage()).append(";");
        }
        return strBuilder.toString();
    }

    public static Throwable getCause(Throwable t) {
        Throwable cause = t.getCause();
        if (Objects.isNull(cause)) {
            return t;
        }
        return cause;
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        t.printStackTrace(ps);
        ps.flush();
        return new String(out.toByteArray());
    }
}

