/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.zookeeper;

import com.alibaba.otter.canal.common.zookeeper.ByteSerializer;
import com.alibaba.otter.canal.common.zookeeper.ZooKeeperx;
import com.google.common.base.Function;
import com.google.common.collect.MigrateMap;
import java.util.Map;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.CreateMode;

public class ZkClientx
extends ZkClient {
    private static Map<String, ZkClientx> clients = MigrateMap.makeComputingMap(new Function<String, ZkClientx>(){

        public ZkClientx apply(String servers) {
            return new ZkClientx(servers);
        }
    });

    public static ZkClientx getZkClient(String servers) {
        return clients.get(servers);
    }

    public ZkClientx(String serverstring) {
        this(serverstring, Integer.MAX_VALUE);
    }

    public ZkClientx(String zkServers, int connectionTimeout) {
        this(new ZooKeeperx(zkServers), connectionTimeout);
    }

    public ZkClientx(String zkServers, int sessionTimeout, int connectionTimeout) {
        this(new ZooKeeperx(zkServers, sessionTimeout), connectionTimeout);
    }

    public ZkClientx(String zkServers, int sessionTimeout, int connectionTimeout, ZkSerializer zkSerializer) {
        this(new ZooKeeperx(zkServers, sessionTimeout), connectionTimeout, zkSerializer);
    }

    private ZkClientx(IZkConnection connection, int connectionTimeout) {
        this(connection, connectionTimeout, new ByteSerializer());
    }

    private ZkClientx(IZkConnection zkConnection, int connectionTimeout, ZkSerializer zkSerializer) {
        super(zkConnection, connectionTimeout, zkSerializer);
    }

    public String createPersistentSequential(String path, boolean createParents) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        try {
            return this.create(path, null, CreateMode.PERSISTENT_SEQUENTIAL);
        }
        catch (ZkNoNodeException e) {
            if (!createParents) {
                throw e;
            }
            String parentDir = path.substring(0, path.lastIndexOf(47));
            this.createPersistent(parentDir, createParents);
            return this.createPersistentSequential(path, createParents);
        }
    }

    public String createPersistentSequential(String path, Object data, boolean createParents) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        try {
            return this.create(path, data, CreateMode.PERSISTENT_SEQUENTIAL);
        }
        catch (ZkNoNodeException e) {
            if (!createParents) {
                throw e;
            }
            String parentDir = path.substring(0, path.lastIndexOf(47));
            this.createPersistent(parentDir, createParents);
            return this.createPersistentSequential(path, data, createParents);
        }
    }

    public void createPersistent(String path, Object data, boolean createParents) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        try {
            this.create(path, data, CreateMode.PERSISTENT);
        }
        catch (ZkNodeExistsException e) {
            if (!createParents) {
                throw e;
            }
        }
        catch (ZkNoNodeException e) {
            if (!createParents) {
                throw e;
            }
            String parentDir = path.substring(0, path.lastIndexOf(47));
            this.createPersistent(parentDir, createParents);
            this.createPersistent(path, data, createParents);
        }
    }
}

