/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common.conflict;

import java.net.URL;
import java.util.Enumeration;

public class PackageConflictDetect {
    private static boolean detectEnable = Boolean.parseBoolean(System.getProperty("com.alibaba.rocketmq.packageConflictDetect.enable", "true"));

    public static void detectFastjson() {
        if (detectEnable) {
            String fastjsonVersion = "1.2.3";
            boolean conflict = false;
            try {
                Enumeration<URL> resources = PackageConflictDetect.class.getClassLoader().getResources("com/alibaba/fastjson/JSON.class");
                while (resources.hasMoreElements()) {
                    System.out.println("fastjson --> " + resources.nextElement());
                }
                String version = "1.2.3";
                int code = version.compareTo("1.2.3");
                if (code < 0) {
                    conflict = true;
                }
            }
            catch (Throwable e) {
                conflict = true;
            }
            if (conflict) {
                throw new RuntimeException(String.format("Your fastjson version is too low, or no fastjson, RocketMQ minimum version required: %s", "1.2.3"));
            }
        }
    }
}

