/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kernel.util;

import java.util.LinkedList;

public class SignContentExtractor {
    public static final char LEFT_BRACE = '{';
    public static final char RIGHT_BRACE = '}';
    public static final char DOUBLE_QUOTES = '\"';

    public String getSignSourceData(String body, String method) {
        String rootNode = method.replace('.', '_') + "_response";
        String errorRootNode = "error_response";
        int indexOfRootNode = body.indexOf(rootNode);
        int indexOfErrorRoot = body.indexOf(errorRootNode);
        if (indexOfRootNode > 0) {
            return this.parseSignSourceData(body, rootNode, indexOfRootNode);
        }
        if (indexOfErrorRoot > 0) {
            return this.parseSignSourceData(body, errorRootNode, indexOfErrorRoot);
        }
        return null;
    }

    private String parseSignSourceData(String body, String rootNode, int indexOfRootNode) {
        int signDataStartIndex = indexOfRootNode + rootNode.length() + 2;
        int indexOfSign = body.indexOf("\"sign\"");
        if (indexOfSign < 0) {
            return null;
        }
        SignSourceData signSourceData = this.extractSignContent(body, signDataStartIndex);
        if (body.lastIndexOf(rootNode) > signSourceData.getEndIndex()) {
            throw new RuntimeException("\u68c0\u6d4b\u5230\u54cd\u5e94\u62a5\u6587\u4e2d\u6709\u91cd\u590d\u7684" + rootNode + "\uff0c\u9a8c\u7b7e\u5931\u8d25\u3002");
        }
        return signSourceData.getSourceData();
    }

    private SignSourceData extractSignContent(String str, int begin) {
        if (str == null) {
            return null;
        }
        int beginIndex = this.extractBeginPosition(str, begin);
        if (beginIndex >= str.length()) {
            return null;
        }
        int endIndex = this.extractEndPosition(str, beginIndex);
        return new SignSourceData(str.substring(beginIndex, endIndex), beginIndex, endIndex);
    }

    private int extractBeginPosition(String responseString, int begin) {
        int beginPosition;
        for (beginPosition = begin; beginPosition < responseString.length() && responseString.charAt(beginPosition) != '{' && responseString.charAt(beginPosition) != '\"'; ++beginPosition) {
        }
        return beginPosition;
    }

    private int extractEndPosition(String responseString, int beginPosition) {
        if (responseString.charAt(beginPosition) == '{') {
            return this.extractJsonObjectEndPosition(responseString, beginPosition);
        }
        return this.extractJsonBase64ValueEndPosition(responseString, beginPosition);
    }

    private int extractJsonBase64ValueEndPosition(String responseString, int beginPosition) {
        for (int index = beginPosition; index < responseString.length(); ++index) {
            if (responseString.charAt(index) != '\"' || index == beginPosition) continue;
            return index + 1;
        }
        return responseString.length();
    }

    private int extractJsonObjectEndPosition(String responseString, int beginPosition) {
        LinkedList<Character> braces = new LinkedList<Character>();
        boolean inQuotes = false;
        int consecutiveEscapeCount = 0;
        for (int index = beginPosition; index < responseString.length(); ++index) {
            char currentChar = responseString.charAt(index);
            if (currentChar == '\"' && consecutiveEscapeCount % 2 == 0) {
                inQuotes = !inQuotes;
            } else if (currentChar == '{' && !inQuotes) {
                braces.push(Character.valueOf('{'));
            } else if (currentChar == '}' && !inQuotes) {
                braces.pop();
                if (braces.isEmpty()) {
                    return index + 1;
                }
            }
            if (currentChar == '\\') {
                ++consecutiveEscapeCount;
                continue;
            }
            consecutiveEscapeCount = 0;
        }
        return responseString.length();
    }

    private static class SignSourceData {
        private final String sourceData;
        private final int beginIndex;
        private final int endIndex;

        SignSourceData(String sourceData, int beginIndex, int endIndex) {
            this.sourceData = sourceData;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        String getSourceData() {
            return this.sourceData;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        int getEndIndex() {
            return this.endIndex;
        }
    }
}

