package com.aliyun.dashvector.common;

import lombok.Getter;

/**
 * @author sanyi
 */
@Getter
public class DashVectorException extends RuntimeException {
  private final int code;

  public DashVectorException(int code, String message) {
    super(message);
    this.code = code;
  }

  public DashVectorException(Exception e, int code) {
    super(e);
    this.code = code;
  }

  public DashVectorException(ErrorCode code) {
    this(code.getCode(), code.getMessage());
  }

  public DashVectorException(ErrorCode code, String message) {
    this(code.getCode(), message);
  }
}
