package com.aliyun.dashvector.common;

import lombok.Getter;

/**
 * @author sanyi
 */
@Getter
public enum ErrorCode {
  TIMEOUT(408, "Timeout"),
  SUCCESS(0, "Success"),
  CLOSED(-998, "Closed"),
  UNKNOWN(-999, "Unknown"),
  EMPTY_COLLECTION_NAME(-2000, "Empty collection name"),
  EMPTY_COLUMN_NAME(-2001, "Empty column name"),
  EMPTY_PARTITION_NAME(-2002, "Empty collection partition name"),
  EMPTY_COLUMNS(-2003, "Empty columns"),
  EMPTY_PRIMARY_KEY(-2004, "Empty primary key"),
  EMPTY_DOC_LIST(-2005, "Empty doc list"),
  EMPTY_DOC_FIELDS(-2006, "Empty doc fields"),
  EMPTY_INDEX_FIELD(-2007, "Empty index field"),
  INVALID_RECORD(-2008, "Invalid Record"),
  INVALID_QUERY(-2009, "Invalid Query"),
  INVALID_WRITE_REQUEST(-2010, "Invalid Write Request"),
  INVALID_VECTOR_FORMAT(-2011, "Invalid Vector Format"),
  INVALID_DATA_TYPE(-2012, "Invalid Data Type"),
  INVALID_INDEX_TYPE(-2013, "Invalid Index Type"),
  INVALID_FEATURE(-2014, "Invalid Feature"),
  INVALID_FILTER(-2015, "Invalid Filter"),
  INVALID_PRIMARY_KEY(-2016, "Invalid primary key"),
  INVALID_FIELD(-2017, "Invalid field"),
  MISMATCHED_INDEX_COLUMN(-2018, "Mismatched Index Column"),
  MISMATCHED_DIMENSION(-2019, "Mismatched Dimension"),
  MISMATCHED_DATA_TYPE(-2020, "Mismatched Data Type"),
  INEXISTENT_COLLECTION(-2021, "DashVectorCollection Not Exist"),
  INEXISTENT_PARTITION(-2022, "Inexistent collection partition"),
  INEXISTENT_COLUMN(-2023, "Column Not Exist"),
  INEXISTENT_KEY(-2024, "Key Not Exist"),
  DUPLICATE_COLLECTION(-2025, "Duplicate DashVectorCollection"),
  DUPLICATE_PARTITION(-2026, "Duplicate collection partition"),
  DUPLICATE_KEY(-2027, "Duplicate Key"),
  DUPLICATE_FIELD(-2028, "Duplicate field"),
  UNREADY_PARTITION(-2029, "Status of collection partition is incorrect"),
  UNREADY_COLLECTION(-2030, "Status of collection is incorrect"),
  UNSUPPORTED_CONDITION(-2031, "Query condition has error or not supported"),
  ORDERBY_NOT_IN_SELECT_ITEMS(-2032, "Order by column must exists in select item list"),
  PB_TO_SQL_INFO_ERROR(-2033, "Pb to sql info error"),
  EXCEED_RATE_LIMIT(-2034, "Exceed Rate Limit"),
  INVALID_SPARSE_VALUES(-2035, "Invalid Sparse Values"),
  INVALID_BATCH_SIZE(-2036, "Invalid batch size"),
  INVALID_DIMENSION(-2037, "Invalid dimension"),
  INVALID_EXTRA_PARAM(-2038, "Invalid extra param"),
  INVALID_RADIUS(-2039, "Invalid radius"),
  INVALID_LINEAR(-2040, "Invalid is linear"),
  INVALID_TOPK(-2041, "Invalid topk"),
  INVALID_COLLECTION_NAME(-2042, "Invalid collection name"),
  INVALID_PARTITION_NAME(-2043, "Invalid partition name"),
  INVALID_FIELD_NAME(-2044, "Invalid field name"),
  INVALID_CHANNEL_COUNT(-2045, "Invalid field name"),
  INVALID_REPLICA_COUNT(-2046, "Invalid field name"),
  INVALID_JSON(-2047, "Invalid json"),
  INVALID_PROTOBUF_MESSAGE(-2048, "Invalid protobuf message"),
  INVALID_GROUP_BY(-2053, "Invalid GroupBy Request"),
  INVALID_SPARSE_INDICES(-2951, "Invalid sparse indices"),
  INVALID_COLLECTION_META(-2921, "Collection meta is invalid"),
  MULTI_VECTOR_NOT_SUPPORT_SPARSE(-2922, "Multi-vector not support sparse vector"),
  INVALID_ENDPOINT(-2952, "Invalid endpoint"),
  EXCEED_IDS_LIMIT(-2967, "Exceed doc limit"),
  INVALID_VECTOR_TYPE(-2968, "Invalid vector type"),
  EXCEED_REQUEST_SIZE(-2970, "Exceed request size"),
  EXIST_VECTOR_ID(-2973, "Vector and id are existed"),
  INVALID_ARGUMENT(-2999, "Invalid argument");

  private final int code;
  private final String message;

  private ErrorCode(int code, String message) {
    this.code = code;
    this.message = message;
  }
}
