package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.common.Constants;
import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.utils.Validator;
import java.util.List;
import lombok.Builder;
import lombok.Getter;
import lombok.NonNull;
import lombok.Singular;

/**
 * @author sanyi
 */
@Getter
@Builder
public class FetchDocRequest {
  @Singular private List<String> ids;
  @Builder.Default @NonNull private String partition = Constants.DEFAULT_PARTITION_NAME;

  public com.aliyun.dashvector.proto.FetchDocRequest toProto() throws DashVectorException {
    verify();
    com.aliyun.dashvector.proto.FetchDocRequest request =
        com.aliyun.dashvector.proto.FetchDocRequest.newBuilder()
            .addAllIds(ids)
            .setPartition(partition)
            .build();
    Validator.verifyRequestSize(request);
    return request;
  }

  private void verify() throws DashVectorException {
    Validator.verifyDocIdList(ids);
    Validator.verifyPartitionName(partition);
  }
}
