package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.utils.Convertor;
import java.util.stream.Collectors;
import lombok.experimental.SuperBuilder;

/**
 * @author sanyi
 */
@SuperBuilder
public class UpsertDocRequest
    extends WriteDocRequest<com.aliyun.dashvector.proto.UpsertDocRequest> {
  @Override
  protected com.aliyun.dashvector.proto.UpsertDocRequest build(CollectionMeta collectionMeta) {
    return com.aliyun.dashvector.proto.UpsertDocRequest.newBuilder()
        .addAllDocs(
            docs.stream().map(doc -> Convertor.toDoc(doc, collectionMeta)).collect(Collectors.toList()))
        .setPartition(partition)
        .build();
  }
}
