package com.aliyun.dashvector.models.requests;

import com.aliyun.dashvector.common.Constants;
import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.Doc;
import com.aliyun.dashvector.proto.DocOpResult;
import com.aliyun.dashvector.utils.Validator;
import com.aliyun.dashvector.validator.ValidatorFactory;
import com.google.protobuf.Message;
import java.util.List;
import lombok.Builder;
import lombok.Getter;
import lombok.Singular;
import lombok.experimental.SuperBuilder;

/**
 * @author sanyi
 */
@Getter
@SuperBuilder(toBuilder = true)
public abstract class WriteDocRequest<T extends Message> {
  @Singular protected List<Doc> docs;
  @Builder.Default protected String partition = Constants.DEFAULT_PARTITION_NAME;

  public final T toProto(CollectionMeta collectionMeta, DocOpResult.DocOp docOp) throws DashVectorException {
    // validate
    ValidatorFactory.create(collectionMeta).validateWriteDocRequest(this, docOp);
    // convertor to protobuf
    T request = build(collectionMeta);
    Validator.verifyRequestSize(request);
    return request;
  }

  protected abstract T build(CollectionMeta collectionMeta);
}
