/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.VectorParam;
import com.aliyun.dashvector.proto.CollectionInfo;
import com.aliyun.dashvector.proto.FieldType;
import com.aliyun.dashvector.proto.Status;
import com.aliyun.dashvector.utils.Convertor;
import com.aliyun.dashvector.utils.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;

public class CollectionMeta
implements Serializable {
    private final String name;
    @JsonProperty(value="dimension")
    private final int dimension;
    @JsonProperty(value="data_type")
    private final CollectionInfo.DataType dataType;
    @JsonProperty(value="metric")
    private final CollectionInfo.Metric metric;
    private final String status;
    @JsonProperty(value="fields_schema")
    private final Map<String, FieldType> fieldsSchema;
    @JsonProperty(value="partition_status")
    private final Map<String, Status> partitionStatus;
    @JsonProperty(value="vectors")
    private final Map<String, VectorParam> vectors;
    @JsonProperty(value="sparse_vectors")
    private final Map<String, VectorParam> sparseVectors;

    public String toString() {
        return Utils.toString(this);
    }

    @JsonIgnore
    public int getDimension() {
        this.checkMultiVectors();
        return this.dimension;
    }

    public int getDimension(String vectorName) {
        return this.getVectorParam(vectorName).getDimension();
    }

    @JsonIgnore
    public CollectionInfo.Metric getMetric() {
        this.checkMultiVectors();
        return this.metric;
    }

    @JsonIgnore
    public CollectionInfo.Metric getMetric(String sparseVectorName) {
        return this.getVectorParam(sparseVectorName).getMetric();
    }

    @JsonIgnore
    public CollectionInfo.DataType getDataType() {
        this.checkMultiVectors();
        return this.dataType;
    }

    public CollectionInfo.DataType getDataType(String vectorName) {
        return this.getVectorParam(vectorName).getDataType();
    }

    public CollectionMeta(CollectionInfo collectionInfo) {
        this.name = collectionInfo.getName();
        this.status = collectionInfo.getStatus().name();
        this.fieldsSchema = collectionInfo.getFieldsSchemaMap();
        this.partitionStatus = collectionInfo.getPartitionsMap();
        int dimension = collectionInfo.getDimension();
        CollectionInfo.DataType dataType = collectionInfo.getDtype();
        CollectionInfo.Metric metric = collectionInfo.getMetric();
        Map<Object, Object> vectorsMap = new HashMap();
        CollectionInfo.VectorParam denseVectorParam = collectionInfo.getVectorsSchemaMap().get("proxima_vector");
        if (denseVectorParam != null) {
            dimension = denseVectorParam.getDimension();
            dataType = denseVectorParam.getDtype();
            metric = denseVectorParam.getMetric();
        } else if (MapUtils.isNotEmpty(collectionInfo.getVectorsSchemaMap())) {
            vectorsMap = collectionInfo.getVectorsSchemaMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Convertor.toVectorParam((CollectionInfo.VectorParam)entry.getValue())));
        }
        this.dimension = dimension;
        this.dataType = dataType;
        this.metric = metric;
        this.vectors = vectorsMap;
        this.sparseVectors = collectionInfo.getSparseVectorsSchemaMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Convertor.toVectorParam((CollectionInfo.VectorParam)entry.getValue())));
    }

    private void checkMultiVectors() {
        if (MapUtils.isNotEmpty(this.vectors) && this.vectors.size() > 1) {
            throw new DashVectorException(ErrorCode.INVALID_ARGUMENT.getCode(), "DashVectorSDK should provide vector name when collection has multi dense vectors");
        }
        if (MapUtils.isNotEmpty(this.sparseVectors)) {
            throw new DashVectorException(ErrorCode.INVALID_ARGUMENT.getCode(), "DashVectorSDK should provide vector name when collection has multi sparse vectors");
        }
    }

    public VectorParam getVectorParam(String vectorName) {
        if (this.vectors.containsKey(vectorName)) {
            return this.vectors.get(vectorName);
        }
        if (this.sparseVectors.containsKey(vectorName)) {
            return this.sparseVectors.get(vectorName);
        }
        throw new DashVectorException(ErrorCode.INVALID_ARGUMENT.getCode(), String.format("DashVectorSDK vector name %s not found", vectorName));
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public Map<String, FieldType> getFieldsSchema() {
        return this.fieldsSchema;
    }

    public Map<String, Status> getPartitionStatus() {
        return this.partitionStatus;
    }

    public Map<String, VectorParam> getVectors() {
        return this.vectors;
    }

    public Map<String, VectorParam> getSparseVectors() {
        return this.sparseVectors;
    }
}

