/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models;

import com.aliyun.dashvector.proto.CollectionInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class VectorParam {
    private int dimension;
    @NonNull
    private CollectionInfo.DataType dataType;
    @NonNull
    private CollectionInfo.Metric metric;
    private String quantizeType;

    private static CollectionInfo.DataType $default$dataType() {
        return CollectionInfo.DataType.FLOAT;
    }

    private static CollectionInfo.Metric $default$metric() {
        return CollectionInfo.Metric.cosine;
    }

    private static String $default$quantizeType() {
        return "";
    }

    VectorParam(int dimension, @NonNull CollectionInfo.DataType dataType, @NonNull CollectionInfo.Metric metric, String quantizeType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (metric == null) {
            throw new NullPointerException("metric is marked non-null but is null");
        }
        this.dimension = dimension;
        this.dataType = dataType;
        this.metric = metric;
        this.quantizeType = quantizeType;
    }

    public static VectorParamBuilder builder() {
        return new VectorParamBuilder();
    }

    public int getDimension() {
        return this.dimension;
    }

    @NonNull
    public CollectionInfo.DataType getDataType() {
        return this.dataType;
    }

    @NonNull
    public CollectionInfo.Metric getMetric() {
        return this.metric;
    }

    public String getQuantizeType() {
        return this.quantizeType;
    }

    public static class VectorParamBuilder {
        private int dimension;
        private boolean dataType$set;
        private CollectionInfo.DataType dataType$value;
        private boolean metric$set;
        private CollectionInfo.Metric metric$value;
        private boolean quantizeType$set;
        private String quantizeType$value;

        VectorParamBuilder() {
        }

        public VectorParamBuilder dimension(int dimension) {
            this.dimension = dimension;
            return this;
        }

        public VectorParamBuilder dataType(@NonNull CollectionInfo.DataType dataType) {
            if (dataType == null) {
                throw new NullPointerException("dataType is marked non-null but is null");
            }
            this.dataType$value = dataType;
            this.dataType$set = true;
            return this;
        }

        public VectorParamBuilder metric(@NonNull CollectionInfo.Metric metric) {
            if (metric == null) {
                throw new NullPointerException("metric is marked non-null but is null");
            }
            this.metric$value = metric;
            this.metric$set = true;
            return this;
        }

        public VectorParamBuilder quantizeType(String quantizeType) {
            this.quantizeType$value = quantizeType;
            this.quantizeType$set = true;
            return this;
        }

        public VectorParam build() {
            CollectionInfo.DataType dataType$value = this.dataType$value;
            if (!this.dataType$set) {
                dataType$value = VectorParam.$default$dataType();
            }
            CollectionInfo.Metric metric$value = this.metric$value;
            if (!this.metric$set) {
                metric$value = VectorParam.$default$metric();
            }
            String quantizeType$value = this.quantizeType$value;
            if (!this.quantizeType$set) {
                quantizeType$value = VectorParam.$default$quantizeType();
            }
            return new VectorParam(this.dimension, dataType$value, metric$value, quantizeType$value);
        }

        public String toString() {
            return "VectorParam.VectorParamBuilder(dimension=" + this.dimension + ", dataType$value=" + this.dataType$value + ", metric$value=" + this.metric$value + ", quantizeType$value=" + this.quantizeType$value + ")";
        }
    }
}

