/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.shaded.io.grpc.internal;

import com.aliyun.dashvector.shaded.io.grpc.Attributes;
import com.aliyun.dashvector.shaded.io.grpc.CallOptions;
import com.aliyun.dashvector.shaded.io.grpc.ClientCall;
import com.aliyun.dashvector.shaded.io.grpc.ClientStreamTracer;
import com.aliyun.dashvector.shaded.io.grpc.ConnectivityState;
import com.aliyun.dashvector.shaded.io.grpc.ConnectivityStateInfo;
import com.aliyun.dashvector.shaded.io.grpc.Context;
import com.aliyun.dashvector.shaded.io.grpc.EquivalentAddressGroup;
import com.aliyun.dashvector.shaded.io.grpc.InternalChannelz;
import com.aliyun.dashvector.shaded.io.grpc.InternalInstrumented;
import com.aliyun.dashvector.shaded.io.grpc.InternalLogId;
import com.aliyun.dashvector.shaded.io.grpc.LoadBalancer;
import com.aliyun.dashvector.shaded.io.grpc.ManagedChannel;
import com.aliyun.dashvector.shaded.io.grpc.Metadata;
import com.aliyun.dashvector.shaded.io.grpc.MethodDescriptor;
import com.aliyun.dashvector.shaded.io.grpc.Status;
import com.aliyun.dashvector.shaded.io.grpc.SynchronizationContext;
import com.aliyun.dashvector.shaded.io.grpc.internal.AbstractSubchannel;
import com.aliyun.dashvector.shaded.io.grpc.internal.CallTracer;
import com.aliyun.dashvector.shaded.io.grpc.internal.ChannelTracer;
import com.aliyun.dashvector.shaded.io.grpc.internal.ClientCallImpl;
import com.aliyun.dashvector.shaded.io.grpc.internal.ClientStream;
import com.aliyun.dashvector.shaded.io.grpc.internal.DelayedClientTransport;
import com.aliyun.dashvector.shaded.io.grpc.internal.GrpcUtil;
import com.aliyun.dashvector.shaded.io.grpc.internal.InternalSubchannel;
import com.aliyun.dashvector.shaded.io.grpc.internal.ManagedClientTransport;
import com.aliyun.dashvector.shaded.io.grpc.internal.ObjectPool;
import com.aliyun.dashvector.shaded.io.grpc.internal.TimeProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class OobChannel
extends ManagedChannel
implements InternalInstrumented<InternalChannelz.ChannelStats> {
    private static final Logger log = Logger.getLogger(OobChannel.class.getName());
    private InternalSubchannel subchannel;
    private AbstractSubchannel subchannelImpl;
    private LoadBalancer.SubchannelPicker subchannelPicker;
    private final InternalLogId logId;
    private final String authority;
    private final DelayedClientTransport delayedTransport;
    private final InternalChannelz channelz;
    private final ObjectPool<? extends Executor> executorPool;
    private final Executor executor;
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private final CountDownLatch terminatedLatch = new CountDownLatch(1);
    private volatile boolean shutdown;
    private final CallTracer channelCallsTracer;
    private final ChannelTracer channelTracer;
    private final TimeProvider timeProvider;
    private final ClientCallImpl.ClientStreamProvider transportProvider = new ClientCallImpl.ClientStreamProvider(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientStream newStream(MethodDescriptor<?, ?> method, CallOptions callOptions, Metadata headers, Context context) {
            ClientStreamTracer[] tracers = GrpcUtil.getClientStreamTracers(callOptions, headers, 0, false);
            Context origContext = context.attach();
            try {
                ClientStream clientStream = OobChannel.this.delayedTransport.newStream(method, headers, callOptions, tracers);
                return clientStream;
            }
            finally {
                context.detach(origContext);
            }
        }
    };

    OobChannel(String authority, ObjectPool<? extends Executor> executorPool, ScheduledExecutorService deadlineCancellationExecutor, SynchronizationContext syncContext, CallTracer callsTracer, ChannelTracer channelTracer, InternalChannelz channelz, TimeProvider timeProvider) {
        this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
        this.logId = InternalLogId.allocate(this.getClass(), authority);
        this.executorPool = (ObjectPool)Preconditions.checkNotNull(executorPool, (Object)"executorPool");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executorPool.getObject(), (Object)"executor");
        this.deadlineCancellationExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)deadlineCancellationExecutor, (Object)"deadlineCancellationExecutor");
        this.delayedTransport = new DelayedClientTransport(this.executor, syncContext);
        this.channelz = (InternalChannelz)Preconditions.checkNotNull((Object)channelz);
        this.delayedTransport.start(new ManagedClientTransport.Listener(){

            @Override
            public void transportShutdown(Status s) {
            }

            @Override
            public void transportTerminated() {
                OobChannel.this.subchannelImpl.shutdown();
            }

            @Override
            public void transportReady() {
            }

            @Override
            public void transportInUse(boolean inUse) {
            }
        });
        this.channelCallsTracer = callsTracer;
        this.channelTracer = (ChannelTracer)Preconditions.checkNotNull((Object)channelTracer, (Object)"channelTracer");
        this.timeProvider = (TimeProvider)Preconditions.checkNotNull((Object)timeProvider, (Object)"timeProvider");
    }

    void setSubchannel(final InternalSubchannel subchannel) {
        log.log(Level.FINE, "[{0}] Created with [{1}]", new Object[]{this, subchannel});
        this.subchannel = subchannel;
        this.subchannelImpl = new AbstractSubchannel(){

            @Override
            public void shutdown() {
                subchannel.shutdown(Status.UNAVAILABLE.withDescription("OobChannel is shutdown"));
            }

            @Override
            InternalInstrumented<InternalChannelz.ChannelStats> getInstrumentedInternalSubchannel() {
                return subchannel;
            }

            @Override
            public void requestConnection() {
                subchannel.obtainActiveTransport();
            }

            @Override
            public List<EquivalentAddressGroup> getAllAddresses() {
                return subchannel.getAddressGroups();
            }

            @Override
            public Attributes getAttributes() {
                return Attributes.EMPTY;
            }

            @Override
            public Object getInternalSubchannel() {
                return subchannel;
            }
        };
        final class OobSubchannelPicker
        extends LoadBalancer.SubchannelPicker {
            final LoadBalancer.PickResult result;

            OobSubchannelPicker() {
                this.result = LoadBalancer.PickResult.withSubchannel(OobChannel.this.subchannelImpl);
            }

            @Override
            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                return this.result;
            }

            public String toString() {
                return MoreObjects.toStringHelper(OobSubchannelPicker.class).add("result", (Object)this.result).toString();
            }
        }
        this.subchannelPicker = new OobSubchannelPicker();
        this.delayedTransport.reprocess(this.subchannelPicker);
    }

    void updateAddresses(List<EquivalentAddressGroup> eag) {
        this.subchannel.updateAddresses(eag);
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return new ClientCallImpl<RequestT, ResponseT>(methodDescriptor, callOptions.getExecutor() == null ? this.executor : callOptions.getExecutor(), callOptions, this.transportProvider, this.deadlineCancellationExecutor, this.channelCallsTracer, null);
    }

    @Override
    public String authority() {
        return this.authority;
    }

    @Override
    public boolean isTerminated() {
        return this.terminatedLatch.getCount() == 0L;
    }

    @Override
    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        return this.terminatedLatch.await(time, unit);
    }

    @Override
    public ConnectivityState getState(boolean requestConnectionIgnored) {
        if (this.subchannel == null) {
            return ConnectivityState.IDLE;
        }
        return this.subchannel.getState();
    }

    @Override
    public ManagedChannel shutdown() {
        this.shutdown = true;
        this.delayedTransport.shutdown(Status.UNAVAILABLE.withDescription("OobChannel.shutdown() called"));
        return this;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public ManagedChannel shutdownNow() {
        this.shutdown = true;
        this.delayedTransport.shutdownNow(Status.UNAVAILABLE.withDescription("OobChannel.shutdownNow() called"));
        return this;
    }

    void handleSubchannelStateChange(final ConnectivityStateInfo newState) {
        this.channelTracer.reportEvent(new InternalChannelz.ChannelTrace.Event.Builder().setDescription("Entering " + (Object)((Object)newState.getState()) + " state").setSeverity(InternalChannelz.ChannelTrace.Event.Severity.CT_INFO).setTimestampNanos(this.timeProvider.currentTimeNanos()).build());
        switch (newState.getState()) {
            case READY: 
            case IDLE: {
                this.delayedTransport.reprocess(this.subchannelPicker);
                break;
            }
            case TRANSIENT_FAILURE: {
                final class OobErrorPicker
                extends LoadBalancer.SubchannelPicker {
                    final LoadBalancer.PickResult errorResult;

                    OobErrorPicker() {
                        this.errorResult = LoadBalancer.PickResult.withError(newState.getStatus());
                    }

                    @Override
                    public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                        return this.errorResult;
                    }

                    public String toString() {
                        return MoreObjects.toStringHelper(OobErrorPicker.class).add("errorResult", (Object)this.errorResult).toString();
                    }
                }
                this.delayedTransport.reprocess(new OobErrorPicker());
                break;
            }
        }
    }

    void handleSubchannelTerminated() {
        this.channelz.removeSubchannel(this);
        this.executorPool.returnObject(this.executor);
        this.terminatedLatch.countDown();
    }

    @VisibleForTesting
    LoadBalancer.Subchannel getSubchannel() {
        return this.subchannelImpl;
    }

    InternalSubchannel getInternalSubchannel() {
        return this.subchannel;
    }

    @Override
    public ListenableFuture<InternalChannelz.ChannelStats> getStats() {
        SettableFuture ret = SettableFuture.create();
        InternalChannelz.ChannelStats.Builder builder = new InternalChannelz.ChannelStats.Builder();
        this.channelCallsTracer.updateBuilder(builder);
        this.channelTracer.updateBuilder(builder);
        builder.setTarget(this.authority).setState(this.subchannel.getState()).setSubchannels(Collections.singletonList(this.subchannel));
        ret.set((Object)builder.build());
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logId", this.logId.getId()).add("authority", (Object)this.authority).toString();
    }

    @Override
    public void resetConnectBackoff() {
        this.subchannel.resetConnectBackoff();
    }
}

