/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.shaded.io.grpc.netty.shaded.io.grpc.netty;

import com.aliyun.dashvector.shaded.io.grpc.EquivalentAddressGroup;
import com.aliyun.dashvector.shaded.io.grpc.NameResolver;
import com.aliyun.dashvector.shaded.io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;

final class UdsNameResolver
extends NameResolver {
    private NameResolver.Listener2 listener;
    private final String authority;

    UdsNameResolver(String authority, String targetPath) {
        Preconditions.checkArgument((authority == null ? 1 : 0) != 0, (Object)"non-null authority not supported");
        this.authority = targetPath;
    }

    @Override
    public String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public void start(NameResolver.Listener2 listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.listener = (NameResolver.Listener2)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.resolve();
    }

    @Override
    public void refresh() {
        this.resolve();
    }

    private void resolve() {
        NameResolver.ResolutionResult.Builder resolutionResultBuilder = NameResolver.ResolutionResult.newBuilder();
        ArrayList<EquivalentAddressGroup> servers = new ArrayList<EquivalentAddressGroup>(1);
        servers.add(new EquivalentAddressGroup(new DomainSocketAddress(this.authority)));
        resolutionResultBuilder.setAddresses(Collections.unmodifiableList(servers));
        this.listener.onResult(resolutionResultBuilder.build());
    }

    @Override
    public void shutdown() {
    }
}

