/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.validator;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.Doc;
import com.aliyun.dashvector.models.SparseVector;
import com.aliyun.dashvector.models.SparseVectorQuery;
import com.aliyun.dashvector.models.Vector;
import com.aliyun.dashvector.models.VectorParam;
import com.aliyun.dashvector.models.VectorQuery;
import com.aliyun.dashvector.models.requests.QueryDocGroupByRequest;
import com.aliyun.dashvector.models.requests.QueryDocRequest;
import com.aliyun.dashvector.proto.DocOpResult;
import com.aliyun.dashvector.utils.Validator;
import com.aliyun.dashvector.validator.VectorValidator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;

public class MultiVectorValidator
extends VectorValidator {
    protected MultiVectorValidator(CollectionMeta meta) {
        super(meta);
    }

    @Override
    protected void validateVectorFromDoc(Doc doc, DocOpResult.DocOp docOp) {
        Map<String, Vector> vectors = doc.getVectors();
        Map<String, SparseVector> sparseVectors = doc.getSparseVectors();
        if (MapUtils.isEmpty(vectors) && MapUtils.isEmpty(sparseVectors)) {
            throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Doc without vector");
        }
        Validator.verifyVectorCount(vectors.size() + sparseVectors.size());
        if (doc.getVector() != null) {
            throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Collection has multi vector but provide single vector in doc");
        }
        if (vectors.containsKey("proxima_vector")) {
            throw new DashVectorException(ErrorCode.INVALID_VECTOR_FORMAT, Validator.RESERVE_DENSE_VECTOR_MSG);
        }
        vectors.forEach((k, v) -> {
            VectorParam vectorParam = this.meta.getVectors().get(k);
            if (vectorParam == null) {
                throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Vector name " + k + " is not exist");
            }
            Validator.verifyVector(v, docOp, vectorParam.getDimension());
        });
        if (MapUtils.isNotEmpty(doc.getSparseVector())) {
            throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Collection has multi vector but provide single sparse vector in doc");
        }
        if (sparseVectors.containsKey("proxima_sparse_vector")) {
            throw new DashVectorException(ErrorCode.INVALID_VECTOR_FORMAT, Validator.RESERVE_SPARSE_VECTOR_MSG);
        }
        sparseVectors.forEach((k, v) -> {
            if (!this.meta.getSparseVectors().containsKey(k)) {
                throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Sparse vector name " + k + " is not exist");
            }
            Validator.verifySparseVector(k, v.getValue(), this.meta);
        });
    }

    @Override
    protected void validateVectorFromQuery(QueryDocRequest request) {
        Map<String, VectorQuery> vectors = request.getVectors();
        Map<String, SparseVectorQuery> sparseVectors = request.getSparseVectors();
        if (MapUtils.isEmpty(vectors) && MapUtils.isEmpty(sparseVectors)) {
            throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Query request without vector");
        }
        Validator.verifyVectorCount(vectors.size() + sparseVectors.size());
        if (request.getVector() != null) {
            throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Collection has multi vector and use vectors to query");
        }
        if (vectors.containsKey("proxima_vector")) {
            throw new DashVectorException(ErrorCode.INVALID_VECTOR_FORMAT, Validator.RESERVE_DENSE_VECTOR_MSG);
        }
        request.getVectors().forEach((k, v) -> {
            VectorParam vectorParam = this.meta.getVectors().get(k);
            if (vectorParam == null) {
                throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Vector name " + k + " is not exist");
            }
            Validator.verifyVector(v.getVector(), DocOpResult.DocOp.UNRECOGNIZED, vectorParam.getDimension());
        });
        if (request.getSparseVector() != null) {
            throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Collection has multi vector and use sparse_vector to query");
        }
        if (vectors.containsKey("proxima_sparse_vector")) {
            throw new DashVectorException(ErrorCode.INVALID_VECTOR_FORMAT, Validator.RESERVE_SPARSE_VECTOR_MSG);
        }
        request.getSparseVectors().forEach((k, v) -> {
            if (!this.meta.getSparseVectors().containsKey(k)) {
                throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Sparse vector name " + k + " is not exist");
            }
            Validator.verifySparseVector(k, v.getVector().getValue(), this.meta);
        });
    }

    @Override
    protected void validateVectorFromQueryGroupBy(QueryDocGroupByRequest request) {
        if (request.getVector() != null) {
            if (Objects.equals(request.getVectorField(), "proxima_vector")) {
                throw new DashVectorException(ErrorCode.INVALID_GROUP_BY, "Collection does not support query group by reverse vector field");
            }
            VectorParam vectorParam = this.meta.getVectors().get(request.getVectorField());
            if (vectorParam == null) {
                throw new DashVectorException(ErrorCode.INVALID_GROUP_BY, "Vector name " + request.getVectorField() + " is not exist");
            }
            Validator.verifyVector(request.getVector(), DocOpResult.DocOp.UNRECOGNIZED, vectorParam.getDimension());
        }
        if (request.getSparseVector() != null) {
            if (Objects.equals(request.getVectorField(), "proxima_sparse_vector")) {
                throw new DashVectorException(ErrorCode.INVALID_GROUP_BY, "Collection does not support query group by reverse vector field");
            }
            if (!this.meta.getSparseVectors().containsKey(request.getVectorField())) {
                throw new DashVectorException(ErrorCode.INVALID_GROUP_BY, "Sparse vector name " + request.getVectorField() + " is not exist");
            }
            Validator.verifySparseVector(request.getSparseVector(), this.meta);
        }
    }
}

