/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.validator;

import com.aliyun.dashvector.common.DashVectorException;
import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.Doc;
import com.aliyun.dashvector.models.requests.QueryDocGroupByRequest;
import com.aliyun.dashvector.models.requests.QueryDocRequest;
import com.aliyun.dashvector.proto.DocOpResult;
import com.aliyun.dashvector.utils.Validator;
import com.aliyun.dashvector.validator.VectorValidator;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ReserveVectorValidator
extends VectorValidator {
    protected ReserveVectorValidator(CollectionMeta meta) {
        super(meta);
    }

    @Override
    protected void validateVectorFromDoc(Doc doc, DocOpResult.DocOp docOp) {
        if (MapUtils.isNotEmpty(doc.getVectors())) {
            throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Collection has only single vector but provide multi vector in doc");
        }
        Validator.verifyVector(doc.getVector(), docOp, this.meta.getDimension());
        Validator.verifySparseVector(doc.getSparseVector(), this.meta);
    }

    @Override
    protected void validateVectorFromQuery(QueryDocRequest request) {
        if (MapUtils.isNotEmpty(request.getVectors())) {
            throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Collection has only single vector but provide multi vector in query");
        }
        if (request.getVectorQuery() != null) {
            if (request.getVector() != null) {
                throw new DashVectorException(ErrorCode.INVALID_ARGUMENT, "Collection has only single vector but provide vector and vector_query");
            }
            Validator.verifyVector(request.getVectorQuery().getVector(), DocOpResult.DocOp.UNRECOGNIZED, this.meta.getDimension());
            Validator.verifyTopK(request.getVectorQuery().getNumCandidates(), request.isIncludeVector());
        } else {
            Validator.verifyVector(request.getVector(), DocOpResult.DocOp.UNRECOGNIZED, this.meta.getDimension());
            Validator.verifyTopK(request.getTopk(), request.isIncludeVector());
        }
        Validator.verifySparseVector(request.getSparseVector(), this.meta);
    }

    @Override
    protected void validateVectorFromQueryGroupBy(QueryDocGroupByRequest request) {
        if (StringUtils.isNotEmpty((CharSequence)request.getVectorField())) {
            throw new DashVectorException(ErrorCode.INVALID_GROUP_BY, "Collection has only vector but does not support query group by vector field");
        }
        Validator.verifyVector(request.getVector(), DocOpResult.DocOp.UNRECOGNIZED, this.meta.getDimension());
        Validator.verifySparseVector(request.getSparseVector(), this.meta);
    }
}

