/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.client.impl.DatahubClientJsonImpl;
import com.aliyun.datahub.client.impl.DatahubClientPbImpl;

public class DatahubClientBuilder {
    private String userAgent;
    private DatahubConfig datahubConfig;
    private HttpConfig httpConfig;

    private DatahubClientBuilder() {
    }

    public static DatahubClientBuilder newBuilder() {
        return new DatahubClientBuilder();
    }

    public DatahubConfig getDatahubConfig() {
        return this.datahubConfig;
    }

    public DatahubClientBuilder setDatahubConfig(DatahubConfig datahubConfig) {
        this.datahubConfig = datahubConfig;
        return this;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public DatahubClientBuilder setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public DatahubClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public DatahubClient build() {
        if (this.datahubConfig == null) {
            throw new InvalidParameterException("DatahubConfig is not set");
        }
        if (this.httpConfig == null) {
            this.httpConfig = new HttpConfig();
        }
        if (this.datahubConfig.isEnableBinary()) {
            return new DatahubClientPbImpl(this.datahubConfig.getEndpoint(), this.datahubConfig.getAccount(), this.httpConfig, this.userAgent);
        }
        return new DatahubClientJsonImpl(this.datahubConfig.getEndpoint(), this.datahubConfig.getAccount(), this.httpConfig, this.userAgent);
    }
}

