/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.LimitExceededException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.exception.ShardSealedException;
import com.aliyun.datahub.client.model.BlobRecordData;
import com.aliyun.datahub.client.model.ListShardResult;
import com.aliyun.datahub.client.model.PutErrorEntry;
import com.aliyun.datahub.client.model.PutRecordsResult;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.ShardEntry;
import com.aliyun.datahub.client.model.ShardState;
import com.aliyun.datahub.client.model.TupleRecordData;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.codec.Charsets;

class Writer {
    private DatahubClient datahubClient = DatahubClientBuilder.newBuilder().setDatahubConfig(new DatahubConfig("", new AliyunAccount("", ""), false)).build();
    private RecordSchema recordSchema = this.datahubClient.getTopic("", "").getRecordSchema();

    public void writeTupleTopic(int maxRetry) {
        ArrayList<String> activeShardIds = new ArrayList<String>();
        try {
            ListShardResult listShardResult = this.datahubClient.listShard("", "");
            for (ShardEntry entry : listShardResult.getShards()) {
                if (entry.getState() != ShardState.ACTIVE) continue;
                activeShardIds.add(entry.getShardId());
            }
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
        block10: for (String shardId : activeShardIds) {
            ArrayList<RecordEntry> recordEntries = new ArrayList<RecordEntry>();
            for (int i = 0; i < 10; ++i) {
                RecordEntry recordEntry = new RecordEntry();
                recordEntry.addAttribute("key1", "value1");
                TupleRecordData data = new TupleRecordData(this.recordSchema);
                data.setField("bigint_field", (Object)i);
                data.setField("timestamp_field", (Object)1234);
                data.setField("string_field", (Object)"hello world");
                data.setField("double_field", (Object)3.14);
                data.setField("boolean_field", (Object)true);
                data.setField("decimal_field", (Object)new BigDecimal(3.14159265359));
                recordEntry.setRecordData(data);
                recordEntry.setShardId(shardId);
                recordEntries.add(recordEntry);
            }
            int retryNum = 0;
            while (retryNum < maxRetry) {
                try {
                    PutRecordsResult res = this.datahubClient.putRecords("", "", recordEntries);
                    System.out.printf("failed data num is %d\n", res.getFailedRecordCount());
                    for (PutErrorEntry entry : res.getPutErrorEntries()) {
                        System.out.println(entry.getIndex() + "\t" + entry.getErrorcode() + "\t" + entry.getMessage());
                    }
                    continue block10;
                }
                catch (InvalidParameterException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (AuthorizationFailureException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (ResourceNotFoundException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (ShardSealedException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (LimitExceededException e) {
                    e.printStackTrace();
                    ++retryNum;
                }
                catch (DatahubClientException e) {
                    e.printStackTrace();
                    ++retryNum;
                }
            }
        }
    }

    public void writeBlobTopic(int maxRetry) {
        ArrayList<String> activeShardIds = new ArrayList<String>();
        try {
            ListShardResult listShardResult = this.datahubClient.listShard("", "");
            for (ShardEntry entry : listShardResult.getShards()) {
                if (entry.getState() != ShardState.ACTIVE) continue;
                activeShardIds.add(entry.getShardId());
            }
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
        block10: for (String shardId : activeShardIds) {
            ArrayList<RecordEntry> recordEntries = new ArrayList<RecordEntry>();
            for (int i = 0; i < 10; ++i) {
                RecordEntry recordEntry = new RecordEntry();
                recordEntry.addAttribute("key2", "value2");
                BlobRecordData data = new BlobRecordData("123456".getBytes(Charsets.UTF_8));
                recordEntry.setRecordData(data);
                recordEntry.setShardId(shardId);
                recordEntries.add(recordEntry);
            }
            int retryNum = 0;
            while (retryNum < maxRetry) {
                try {
                    PutRecordsResult res = this.datahubClient.putRecords("", "", recordEntries);
                    System.out.printf("failed data num is %d\n", res.getFailedRecordCount());
                    for (PutErrorEntry entry : res.getPutErrorEntries()) {
                        System.out.println(entry.getIndex() + "\t" + entry.getErrorcode() + "\t" + entry.getMessage());
                    }
                    continue block10;
                }
                catch (InvalidParameterException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (AuthorizationFailureException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (ResourceNotFoundException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (ShardSealedException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (LimitExceededException e) {
                    e.printStackTrace();
                    ++retryNum;
                }
                catch (DatahubClientException e) {
                    e.printStackTrace();
                    ++retryNum;
                }
            }
        }
    }

    public void writeByDifferentWay() {
        ArrayList<RecordEntry> recordEntries = new ArrayList<RecordEntry>();
        String shardId = "0";
        RecordEntry entry1 = new RecordEntry();
        BlobRecordData data1 = new BlobRecordData("123456".getBytes(Charsets.UTF_8));
        entry1.setRecordData(data1);
        entry1.setShardId(shardId);
        RecordEntry entry2 = new RecordEntry();
        BlobRecordData data2 = new BlobRecordData("123456".getBytes(Charsets.UTF_8));
        entry2.setRecordData(data2);
        String hashKey = "7FFFFFFFFFFFFFFD7FFFFFFFFFFFFFFD";
        entry2.setHashKey(hashKey);
        RecordEntry entry3 = new RecordEntry();
        BlobRecordData data3 = new BlobRecordData("123456".getBytes(Charsets.UTF_8));
        entry3.setRecordData(data3);
        String partitionKey = "testPartitionKey";
        entry3.setPartitionKey(partitionKey);
        RecordEntry entry4 = new RecordEntry();
        BlobRecordData data4 = new BlobRecordData("123456".getBytes(Charsets.UTF_8));
        entry4.setRecordData(data4);
        recordEntries.add(entry4);
        try {
            PutRecordsResult result = this.datahubClient.putRecords("", "", recordEntries);
            System.out.printf("failed data num is %d\n", result.getFailedRecordCount());
            for (PutErrorEntry entry : result.getPutErrorEntries()) {
                System.out.println(entry.getIndex() + "\t" + entry.getErrorcode() + "\t" + entry.getMessage());
            }
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

