/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.interceptor;

import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.http.interceptor.HttpInterceptor;
import com.aliyun.datahub.client.util.JsonUtils;
import com.aliyun.datahub.shaded.okhttp3.Interceptor;
import com.aliyun.datahub.shaded.okhttp3.Request;
import com.aliyun.datahub.shaded.okhttp3.Response;
import com.aliyun.datahub.shaded.okhttp3.ResponseBody;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatahubResponseInterceptor
extends HttpInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatahubResponseInterceptor.class);

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.execute(chain.request(), chain);
    }

    private Response execute(Request request, Interceptor.Chain chain) throws IOException {
        int status;
        Response response = chain.proceed(request);
        String requestId = response.header("x-datahub-request-id");
        if (requestId == null) {
            LOGGER.warn("requestId is null");
        }
        if ((status = response.code()) >= 400) {
            DatahubResponseError error = new DatahubResponseError();
            String contentType = response.header("Content-Type".toLowerCase());
            ResponseBody body = response.body();
            if (body != null) {
                if ("application/json".equalsIgnoreCase(contentType)) {
                    String bodyStr = body.string();
                    error = JsonUtils.fromJson(bodyStr, DatahubResponseError.class);
                } else {
                    error = new DatahubResponseError();
                    error.setMessage(body.string());
                }
            }
            throw new DatahubClientException(status, requestId, error == null ? "" : error.getCode(), error == null ? "" : error.getMessage());
        }
        return response;
    }

    private static class DatahubResponseError {
        @JsonProperty(value="RequestId")
        private String requestId;
        @JsonProperty(value="ErrorCode")
        private String code;
        @JsonProperty(value="ErrorMessage")
        private String message;

        private DatahubResponseError() {
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

