/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.serializer;

import com.aliyun.datahub.client.model.ConnectorConfig;
import com.aliyun.datahub.client.model.SinkConfig;
import com.aliyun.datahub.client.model.SinkDatahubConfig;
import com.aliyun.datahub.client.model.SinkEsConfig;
import com.aliyun.datahub.client.model.SinkFcConfig;
import com.aliyun.datahub.client.model.SinkHologresConfig;
import com.aliyun.datahub.client.model.SinkMysqlConfig;
import com.aliyun.datahub.client.model.SinkOdpsConfig;
import com.aliyun.datahub.client.model.SinkOssConfig;
import com.aliyun.datahub.client.model.SinkOtsConfig;
import com.aliyun.datahub.client.model.SourceDtsConfig;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConnectorConfigSerializer
extends JsonSerializer<ConnectorConfig> {
    public void serialize(ConnectorConfig connectorConfig, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();
        if (connectorConfig instanceof SinkOdpsConfig) {
            this.serializeOdpsConfig((SinkOdpsConfig)connectorConfig, jsonGenerator);
        } else if (connectorConfig instanceof SinkMysqlConfig) {
            this.serializeDatabaseConfig((SinkMysqlConfig)connectorConfig, jsonGenerator);
        } else if (connectorConfig instanceof SinkHologresConfig) {
            this.serializeHologresConfig((SinkHologresConfig)connectorConfig, jsonGenerator);
        } else if (connectorConfig instanceof SinkDatahubConfig) {
            this.serializeDatahubConfig((SinkDatahubConfig)connectorConfig, jsonGenerator);
        } else if (connectorConfig instanceof SinkEsConfig) {
            this.serializeEsConfig((SinkEsConfig)connectorConfig, jsonGenerator);
        } else if (connectorConfig instanceof SinkFcConfig) {
            this.serializeFcConfig((SinkFcConfig)connectorConfig, jsonGenerator);
        } else if (connectorConfig instanceof SinkOtsConfig) {
            this.serializeOtsConfig((SinkOtsConfig)connectorConfig, jsonGenerator);
        } else if (connectorConfig instanceof SinkOssConfig) {
            this.serializeOssConfig((SinkOssConfig)connectorConfig, jsonGenerator);
        } else if (connectorConfig instanceof SourceDtsConfig) {
            this.serializeDtsConfig((SourceDtsConfig)connectorConfig, jsonGenerator);
        } else {
            throw new IOException("Unknown connector config type");
        }
        jsonGenerator.writeEndObject();
    }

    private void serializeCommonConfig(ConnectorConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        if (config.getTimestampUnit() != null) {
            jsonGenerator.writeStringField("TimestampUnit", config.getTimestampUnit().name());
        }
    }

    private void serializeOdpsConfig(SinkOdpsConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        this.serializeCommonConfig(config, jsonGenerator);
        if (config.getProject() != null) {
            jsonGenerator.writeStringField("Project", config.getProject());
        }
        if (config.getTable() != null) {
            jsonGenerator.writeStringField("Table", config.getTable());
        }
        if (config.getEndpoint() != null) {
            jsonGenerator.writeStringField("OdpsEndpoint", config.getEndpoint());
        }
        if (!StringUtils.isEmpty((CharSequence)config.getTunnelEndpoint())) {
            jsonGenerator.writeStringField("TunnelEndpoint", config.getTunnelEndpoint());
        }
        if (config.getAccessId() != null) {
            jsonGenerator.writeStringField("AccessId", config.getAccessId());
        }
        if (config.getAccessKey() != null) {
            jsonGenerator.writeStringField("AccessKey", config.getAccessKey());
        }
        if (config.getSplitKey() != null) {
            jsonGenerator.writeStringField("SplitKey", config.getSplitKey());
        }
        if (config.getInternalConfig() != null) {
            SinkOdpsConfig.InternalConfig internalConfig = config.getInternalConfig();
            if (internalConfig.getSinkCompressData() != null) {
                jsonGenerator.writeStringField("SinkCompressData", String.valueOf(internalConfig.getSinkCompressData()));
            }
            if (internalConfig.getAddTtHostLine() != null) {
                jsonGenerator.writeStringField("AddTtHostLine", String.valueOf(internalConfig.getAddTtHostLine()));
            }
            if (internalConfig.getAplusDataType() != null) {
                jsonGenerator.writeStringField("AplusDataType", String.valueOf(internalConfig.getAplusDataType()));
            }
            if (internalConfig.getSubId() != null) {
                jsonGenerator.writeStringField("SubscriptionId", internalConfig.getSubId());
            }
        }
        if (config.getBase64Encode() != null) {
            jsonGenerator.writeStringField("Base64Encode", String.valueOf(config.getBase64Encode()));
        }
        if (config.getPartitionMode() != null) {
            jsonGenerator.writeStringField("PartitionMode", config.getPartitionMode().name());
            if (config.getPartitionMode() != SinkOdpsConfig.PartitionMode.USER_DEFINE) {
                jsonGenerator.writeNumberField("TimeRange", config.getTimeRange());
                if (config.getTimeZone() != null) {
                    jsonGenerator.writeStringField("TimeZone", config.getTimeZone());
                }
                if (config.getPartitionConfig() != null) {
                    jsonGenerator.writeObjectFieldStart("PartitionConfig");
                    for (Map.Entry<String, String> entry : config.getPartitionConfig().getConfigMap().entrySet()) {
                        jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
                    }
                    jsonGenerator.writeEndObject();
                }
            }
        }
    }

    private void serializeDatabaseConfig(SinkMysqlConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        this.serializeCommonConfig(config, jsonGenerator);
        if (config.getHost() != null) {
            jsonGenerator.writeStringField("Host", config.getHost());
        }
        jsonGenerator.writeStringField("Port", String.valueOf(config.getPort()));
        if (config.getDatabase() != null) {
            jsonGenerator.writeStringField("Database", config.getDatabase());
        }
        if (config.getTable() != null) {
            jsonGenerator.writeStringField("Table", config.getTable());
        }
        if (config.getUser() != null) {
            jsonGenerator.writeStringField("User", config.getUser());
        }
        if (config.getPassword() != null) {
            jsonGenerator.writeStringField("Password", config.getPassword());
        }
        jsonGenerator.writeStringField("Ignore", String.valueOf(config.getInsertMode() == SinkMysqlConfig.InsertMode.IGNORE));
    }

    private void serializeDatahubConfig(SinkDatahubConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        this.serializeCommonConfig(config, jsonGenerator);
        if (config.getEndpoint() != null) {
            jsonGenerator.writeStringField("Endpoint", config.getEndpoint());
        }
        if (config.getProjectName() != null) {
            jsonGenerator.writeStringField("Project", config.getProjectName());
        }
        if (config.getTopicName() != null) {
            jsonGenerator.writeStringField("Topic", config.getTopicName());
        }
        if (config.getAuthMode() != null) {
            jsonGenerator.writeStringField("AuthMode", config.getAuthMode().name().toLowerCase());
            if (config.getAuthMode() == SinkConfig.AuthMode.AK) {
                jsonGenerator.writeStringField("AccessId", config.getAccessId());
                jsonGenerator.writeStringField("AccessKey", config.getAccessKey());
            }
        }
    }

    private void serializeHologresConfig(SinkHologresConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        this.serializeDatahubConfig(config, jsonGenerator);
        if (config.getInstanceId() != null) {
            jsonGenerator.writeStringField("InstanceId", config.getInstanceId());
        }
    }

    private void serializeEsConfig(SinkEsConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        this.serializeCommonConfig(config, jsonGenerator);
        if (config.getIndex() != null) {
            jsonGenerator.writeStringField("Index", config.getIndex());
        }
        if (config.getEndpoint() != null) {
            jsonGenerator.writeStringField("Endpoint", config.getEndpoint());
        }
        if (config.getUser() != null) {
            jsonGenerator.writeStringField("User", config.getUser());
        }
        if (config.getPassword() != null) {
            jsonGenerator.writeStringField("Password", config.getPassword());
        }
        if (config.getIdFields() != null) {
            jsonGenerator.writeArrayFieldStart("IDFields");
            for (String field : config.getIdFields()) {
                jsonGenerator.writeString(field);
            }
            jsonGenerator.writeEndArray();
        }
        if (config.getTypeFields() != null) {
            jsonGenerator.writeArrayFieldStart("TypeFields");
            for (String field : config.getTypeFields()) {
                jsonGenerator.writeString(field);
            }
            jsonGenerator.writeEndArray();
        }
        if (config.getRouterFields() != null) {
            jsonGenerator.writeArrayFieldStart("RouterFields");
            for (String field : config.getRouterFields()) {
                jsonGenerator.writeString(field);
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeStringField("ProxyMode", String.valueOf(config.isProxyMode()));
    }

    private void serializeFcConfig(SinkFcConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        this.serializeCommonConfig(config, jsonGenerator);
        if (config.getEndpoint() != null) {
            jsonGenerator.writeStringField("Endpoint", config.getEndpoint());
        }
        if (config.getService() != null) {
            jsonGenerator.writeStringField("Service", config.getService());
        }
        if (config.getFunction() != null) {
            jsonGenerator.writeStringField("Function", config.getFunction());
        }
        if (config.getAuthMode() != null) {
            jsonGenerator.writeStringField("AuthMode", config.getAuthMode().name().toLowerCase());
            if (config.getAuthMode() == SinkConfig.AuthMode.AK) {
                jsonGenerator.writeStringField("AccessId", config.getAccessId());
                jsonGenerator.writeStringField("AccessKey", config.getAccessKey());
            }
        }
        if (config.getInvokeType() != null) {
            jsonGenerator.writeStringField("InvokeType", config.getInvokeType().name().toLowerCase());
        }
    }

    private void serializeOtsConfig(SinkOtsConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        this.serializeCommonConfig(config, jsonGenerator);
        if (config.getEndpoint() != null) {
            jsonGenerator.writeStringField("Endpoint", config.getEndpoint());
        }
        if (config.getInstance() != null) {
            jsonGenerator.writeStringField("InstanceName", config.getInstance());
        }
        if (config.getTable() != null) {
            jsonGenerator.writeStringField("TableName", config.getTable());
        }
        jsonGenerator.writeStringField("WriteMode", config.getWriteMode().name());
        if (config.getAuthMode() != null) {
            jsonGenerator.writeStringField("AuthMode", config.getAuthMode().name().toLowerCase());
            if (config.getAuthMode() == SinkConfig.AuthMode.AK) {
                jsonGenerator.writeStringField("AccessId", config.getAccessId());
                jsonGenerator.writeStringField("AccessKey", config.getAccessKey());
            }
        }
    }

    private void serializeOssConfig(SinkOssConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        this.serializeCommonConfig(config, jsonGenerator);
        if (config.getEndpoint() != null) {
            jsonGenerator.writeStringField("Endpoint", config.getEndpoint());
        }
        if (config.getBucket() != null) {
            jsonGenerator.writeStringField("Bucket", config.getBucket());
        }
        if (config.getPrefix() != null) {
            jsonGenerator.writeStringField("Prefix", config.getPrefix());
        }
        if (config.getTimeFormat() != null) {
            jsonGenerator.writeStringField("TimeFormat", config.getTimeFormat());
        }
        jsonGenerator.writeNumberField("TimeRange", config.getTimeRange());
        if (config.getAuthMode() != null) {
            jsonGenerator.writeStringField("AuthMode", config.getAuthMode().name().toLowerCase());
            if (config.getAuthMode() == SinkConfig.AuthMode.AK) {
                jsonGenerator.writeStringField("AccessId", config.getAccessId());
                jsonGenerator.writeStringField("AccessKey", config.getAccessKey());
            }
        }
    }

    private void serializeDtsConfig(SourceDtsConfig config, JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        this.serializeCommonConfig(config, jsonGenerator);
        if (config.getEndpoint() != null) {
            jsonGenerator.writeStringField("Endpoint", config.getEndpoint());
        }
        if (config.getTopic() != null) {
            jsonGenerator.writeStringField("Topic", config.getTopic());
        }
        if (config.getSubId() != null) {
            jsonGenerator.writeStringField("SubId", config.getSubId());
        }
        if (config.getUser() != null) {
            jsonGenerator.writeStringField("User", config.getUser());
        }
        if (config.getPassword() != null) {
            jsonGenerator.writeStringField("Password", config.getPassword());
        }
        if (config.getIdFields() != null) {
            jsonGenerator.writeArrayFieldStart("IDFields");
            for (String field : config.getIdFields()) {
                jsonGenerator.writeString(field);
            }
            jsonGenerator.writeEndArray();
        }
    }
}

