/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.model;

import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.impl.serializer.RecordSchemaDeserializer;
import com.aliyun.datahub.client.impl.serializer.RecordSchemaSerializer;
import com.aliyun.datahub.client.model.Field;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonSerialize(using=RecordSchemaSerializer.class)
@JsonDeserialize(using=RecordSchemaDeserializer.class)
public class RecordSchema {
    private List<Field> fieldList = new ArrayList<Field>();
    private Map<String, Field> fieldMap = new HashMap<String, Field>();

    public void addField(Field field) {
        if (field == null) {
            throw new InvalidParameterException("Field is null");
        }
        if (this.fieldMap.containsKey(field.getName())) {
            throw new InvalidParameterException("Field already exists");
        }
        this.fieldMap.put(field.getName(), field);
        this.fieldList.add(field);
    }

    public Field getField(String name) {
        if (name == null) {
            throw new InvalidParameterException("Name is null");
        }
        return this.fieldMap.get(name.toLowerCase());
    }

    public Field getField(int idx) {
        if (idx < 0 || idx >= this.fieldList.size()) {
            throw new InvalidParameterException("idx out of range");
        }
        return this.fieldList.get(idx);
    }

    public int getFieldIndex(String name) {
        if (name == null) {
            throw new InvalidParameterException("Field name is null");
        }
        Field field = this.getField(name);
        return this.fieldList.indexOf(field);
    }

    public List<Field> getFields() {
        return this.fieldList;
    }

    public boolean containsField(String filedName) {
        return this.fieldMap.containsKey(filedName.toLowerCase());
    }
}

