/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.model;

import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.MalformedRecordException;
import com.aliyun.datahub.client.model.Field;
import com.aliyun.datahub.client.model.RecordData;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.util.ValueCheckUtils;
import java.math.BigDecimal;
import java.util.List;

public class TupleRecordData
extends RecordData {
    private RecordSchema recordSchema;
    private Object[] values;
    private int internalIndex = 0;
    private String[] internalAuxValues;

    public TupleRecordData(RecordSchema recordSchema) {
        this.initData(recordSchema);
    }

    private void initData(RecordSchema schema) {
        this.recordSchema = schema;
        this.values = new Object[this.recordSchema.getFields().size()];
    }

    public void setField(String name, Object value) {
        if (!this.recordSchema.containsField(name)) {
            throw new InvalidParameterException("Field [" + name + "] not exist");
        }
        Field field = this.recordSchema.getField(name);
        if (!this.isFieldValid(field, value)) {
            throw new InvalidParameterException("Value is not consistent with schema, field type:" + (Object)((Object)field.getType()));
        }
        int index = this.recordSchema.getFields().indexOf(field);
        this.values[index] = value;
    }

    public void setField(int index, Object value) {
        if (index >= this.recordSchema.getFields().size()) {
            throw new InvalidParameterException("Field index out of range");
        }
        Field field = this.recordSchema.getFields().get(index);
        if (!this.isFieldValid(field, value)) {
            throw new InvalidParameterException("Value is not consistent with schema");
        }
        this.values[index] = value;
    }

    public Object getField(String name) {
        Field field = this.recordSchema.getField(name);
        int index = this.recordSchema.getFields().indexOf(field);
        if (index < this.values.length) {
            return this.values[index];
        }
        return null;
    }

    public Object getField(int idx) {
        Field field = this.recordSchema.getField(idx);
        int index = this.recordSchema.getFields().indexOf(field);
        if (index < this.values.length) {
            return this.values[index];
        }
        return null;
    }

    public RecordSchema getRecordSchema() {
        return this.recordSchema;
    }

    private boolean isFieldValid(Field field, Object value) {
        if (value == null) {
            if (field.isAllowNull()) {
                return true;
            }
            throw new InvalidParameterException("field: " + field.getName() + " not allow null");
        }
        switch (field.getType()) {
            case STRING: {
                return ValueCheckUtils.checkString(value);
            }
            case BIGINT: {
                return ValueCheckUtils.checkBigint(value);
            }
            case DOUBLE: {
                return ValueCheckUtils.checkDouble(value);
            }
            case BOOLEAN: {
                return ValueCheckUtils.checkBoolean(value);
            }
            case TIMESTAMP: {
                return ValueCheckUtils.checkTimestamp(value);
            }
            case DECIMAL: {
                return ValueCheckUtils.checkDecimal(value);
            }
        }
        return false;
    }

    public TupleRecordData(int valueSize) {
        this.internalAuxValues = new String[valueSize];
    }

    public void internalAddValue(String value) {
        this.internalAuxValues[this.internalIndex++] = value;
    }

    public void internalConvertAuxValues(RecordSchema schema) throws DatahubClientException {
        this.initData(schema);
        List<Field> fields = schema.getFields();
        for (int i = 0; i < fields.size() && i < this.internalAuxValues.length; ++i) {
            Field field = fields.get(i);
            String obj = this.internalAuxValues[i];
            if (obj == null) {
                if (field.isAllowNull()) continue;
                throw new MalformedRecordException("Field: " + field.getName() + " not allow null");
            }
            try {
                switch (field.getType()) {
                    case BOOLEAN: {
                        if (!"true".equalsIgnoreCase(obj) && !"false".equalsIgnoreCase(obj)) {
                            throw new MalformedRecordException("Invalid boolean value: " + obj);
                        }
                        this.values[i] = Boolean.parseBoolean(obj);
                        break;
                    }
                    case DOUBLE: {
                        this.values[i] = Double.parseDouble(obj);
                        break;
                    }
                    case STRING: {
                        this.values[i] = obj;
                        break;
                    }
                    case BIGINT: 
                    case TIMESTAMP: {
                        this.values[i] = Long.parseLong(obj);
                        break;
                    }
                    case DECIMAL: {
                        this.values[i] = new BigDecimal(obj);
                    }
                }
                continue;
            }
            catch (NumberFormatException e) {
                throw new MalformedRecordException("Invalid type cast. type: " + field.getType().name() + ", value:" + obj);
            }
        }
    }
}

