/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.shaded.retrofit2;

import com.aliyun.datahub.shaded.retrofit2.Response;
import com.aliyun.datahub.shaded.retrofit2.Utils;
import javax.annotation.Nullable;

public class HttpException
extends RuntimeException {
    private final int code;
    private final String message;
    private final transient Response<?> response;

    private static String getMessage(Response<?> response) {
        Utils.checkNotNull(response, "response == null");
        return "HTTP " + response.code() + " " + response.message();
    }

    public HttpException(Response<?> response) {
        super(HttpException.getMessage(response));
        this.code = response.code();
        this.message = response.message();
        this.response = response;
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    @Nullable
    public Response<?> response() {
        return this.response;
    }
}

