/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.aliyun.logservice;

import com.aliyun.ms.MetaClient;
import com.aliyun.ms.utils.EndpointEnum;
import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.loghub.client.config.LogHubCursorPosition;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.aliyun.logservice.LoghubReceiver;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.Receiver;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001=\u0011!\u0003T8hQV\u0014\u0017J\u001c9vi\u0012\u001bFO]3b[*\u00111\u0001B\u0001\u000bY><7/\u001a:wS\u000e,'BA\u0003\u0007\u0003\u0019\tG.[=v]*\u0011q\u0001C\u0001\ngR\u0014X-Y7j]\u001eT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003E\u0002\u0012)Yi\u0011A\u0005\u0006\u0003'\u0019\tq\u0001Z:ue\u0016\fW.\u0003\u0002\u0016%\t!\"+Z2fSZ,'/\u00138qkR$5\u000b\u001e:fC6\u00042a\u0006\u000e\u001d\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"!B!se\u0006L\bCA\f\u001e\u0013\tq\u0002D\u0001\u0003CsR,\u0007\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\t}\u001b8o\u0019\t\u0003E\rj\u0011AB\u0005\u0003I\u0019\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;)\u0005}1\u0003CA\f(\u0013\tA\u0003DA\u0005ue\u0006t7/[3oi\"A!\u0006\u0001B\u0001B\u0003%1&A\tm_\u001e\u001cVM\u001d<jG\u0016\u0004&o\u001c6fGR\u0004\"\u0001L\u0018\u000f\u0005]i\u0013B\u0001\u0018\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059B\u0002\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u00191|wm\u0015;pe\u0016t\u0015-\\3\t\u0011U\u0002!\u0011!Q\u0001\n-\nq\u0003\\8hQV\u00147i\u001c8tk6,'o\u0012:pkBt\u0015-\\3\t\u0011]\u0002!\u0011!Q\u0001\n-\na\u0003\\8hQV\u0014\u0017J\\:uC:\u001cWMT1nK\n\u000b7/\u001a\u0005\ts\u0001\u0011\t\u0019!C\u0001u\u0005qAn\\4ik\n,e\u000e\u001a9pS:$X#A\u0016\t\u0011q\u0002!\u00111A\u0005\u0002u\n!\u0003\\8hQV\u0014WI\u001c3q_&tGo\u0018\u0013fcR\u0011a(\u0011\t\u0003/}J!\u0001\u0011\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005n\n\t\u00111\u0001,\u0003\rAH%\r\u0005\t\t\u0002\u0011\t\u0011)Q\u0005W\u0005yAn\\4ik\n,e\u000e\u001a9pS:$\b\u0005\u0003\u0005G\u0001\t\u0005\r\u0011\"\u0001;\u0003-\t7mY3tg.+\u00170\u00133\t\u0011!\u0003!\u00111A\u0005\u0002%\u000bq\"Y2dKN\u001c8*Z=JI~#S-\u001d\u000b\u0003})CqAQ$\u0002\u0002\u0003\u00071\u0006\u0003\u0005M\u0001\t\u0005\t\u0015)\u0003,\u00031\t7mY3tg.+\u00170\u00133!\u0011!q\u0005A!a\u0001\n\u0003Q\u0014aD1dG\u0016\u001c8oS3z'\u0016\u001c'/\u001a;\t\u0011A\u0003!\u00111A\u0005\u0002E\u000b1#Y2dKN\u001c8*Z=TK\u000e\u0014X\r^0%KF$\"A\u0010*\t\u000f\t{\u0015\u0011!a\u0001W!AA\u000b\u0001B\u0001B\u0003&1&\u0001\tbG\u000e,7o]&fsN+7M]3uA!Aa\u000b\u0001B\u0001B\u0003%q+\u0001\u0007ti>\u0014\u0018mZ3MKZ,G\u000e\u0005\u0002Y76\t\u0011L\u0003\u0002[\u0011\u000591\u000f^8sC\u001e,\u0017B\u0001/Z\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011!q\u0006A!A!\u0002\u0013y\u0016AD2veN|'\u000fU8tSRLwN\u001c\t\u0003A2l\u0011!\u0019\u0006\u0003E\u000e\faaY8oM&<'B\u00013f\u0003\u0019\u0019G.[3oi*\u0011amZ\u0001\u0007Y><\u0007.\u001e2\u000b\u0005!L\u0017\u0001D8qK:\u001cXM\u001d<jG\u0016\u001c(BA\u0003k\u0015\u0005Y\u0017aA2p[&\u0011Q.\u0019\u0002\u0015\u0019><\u0007*\u001e2DkJ\u001cxN\u001d)pg&$\u0018n\u001c8\t\u0011=\u0004!\u0011!Q\u0001\nA\fa#\u001c'pO\",(mQ;sg>\u00148\u000b^1siRKW.\u001a\t\u0003/EL!A\u001d\r\u0003\u0007%sG\u000f\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003v\u000311wN]2f'B,7-[1m!\t9b/\u0003\u0002x1\t9!i\\8mK\u0006t\u0007\"B=\u0001\t\u0003Q\u0018A\u0002\u001fj]&$h\b\u0006\f|{z|\u0018\u0011AA\u0002\u0003\u000b\t9!!\u0003\u0002\f\u00055\u0011qBA\t!\ta\b!D\u0001\u0003\u0011\u0015\u0001\u0003\u00101\u0001\"\u0011\u0015Q\u0003\u00101\u0001,\u0011\u0015\u0019\u0004\u00101\u0001,\u0011\u0015)\u0004\u00101\u0001,\u0011\u00159\u0004\u00101\u0001,\u0011\u0015I\u0004\u00101\u0001,\u0011\u00151\u0005\u00101\u0001,\u0011\u0015q\u0005\u00101\u0001,\u0011\u00151\u0006\u00101\u0001X\u0011\u0015q\u0006\u00101\u0001`\u0011\u0015y\u0007\u00101\u0001q\u0011\u0015!\b\u00101\u0001v\u0011%\t)\u0002\u0001b\u0001\n\u0003\t9\"A\bn\u0007>t7/^7f\u0013:|%\u000fZ3s+\u0005)\bbBA\u000e\u0001\u0001\u0006I!^\u0001\u0011[\u000e{gn];nK&swJ\u001d3fe\u0002B\u0011\"a\b\u0001\u0005\u0004%\t!!\t\u000215DU-\u0019:u\u0005\u0016\fG/\u00138uKJ4\u0018\r\\'jY2L7/\u0006\u0002\u0002$A\u0019q#!\n\n\u0007\u0005\u001d\u0002D\u0001\u0003M_:<\u0007\u0002CA\u0016\u0001\u0001\u0006I!a\t\u000235DU-\u0019:u\u0005\u0016\fG/\u00138uKJ4\u0018\r\\'jY2L7\u000f\t\u0005\n\u0003_\u0001!\u0019!C\u0001\u0003C\tq\u0003Z1uC\u001a+Go\u00195J]R,'O^1m\u001b&dG.[:\t\u0011\u0005M\u0002\u0001)A\u0005\u0003G\t\u0001\u0004Z1uC\u001a+Go\u00195J]R,'O^1m\u001b&dG.[:!\u0011%\t9\u0004\u0001b\u0001\n\u0003\t\t#A\u0007cCR\u001c\u0007.\u00138uKJ4\u0018\r\u001c\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u0002$\u0005q!-\u0019;dQ&sG/\u001a:wC2\u0004\u0003\u0002CA \u0001\u0001\u0007I\u0011\u0001\u001e\u0002\u001bM,7-\u001e:jif$vn[3o\u0011%\t\u0019\u0005\u0001a\u0001\n\u0003\t)%A\ttK\u000e,(/\u001b;z)>\\WM\\0%KF$2APA$\u0011!\u0011\u0015\u0011IA\u0001\u0002\u0004Y\u0003bBA&\u0001\u0001\u0006KaK\u0001\u000fg\u0016\u001cWO]5usR{7.\u001a8!\u0011)\ty\u0005\u0001EC\u0002\u0013\u0005\u0011\u0011K\u0001\ng2\u001c8\t\\5f]R,\"!a\u0015\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017h\u0003\rawnZ\u0005\u0005\u0003;\n9F\u0001\u0004DY&,g\u000e\u001e\u0005\u000b\u0003C\u0002\u0001\u0012!Q!\n\u0005M\u0013AC:mg\u000ec\u0017.\u001a8uA!\u001a\u0011q\f\u0014\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j\u0005Yq-\u001a;SK\u000e,\u0017N^3s)\t\tY\u0007E\u0003\u0002n\u0005Md#\u0004\u0002\u0002p)\u0019\u0011\u0011\u000f\u0004\u0002\u0011I,7-Z5wKJLA!!\u001e\u0002p\tA!+Z2fSZ,'\u000f\u0003\u0004z\u0001\u0011\u0005\u0011\u0011\u0010\u000b\u0014w\u0006m\u0014qPAA\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0015Q\u0012\u0005\u0007A\u0005]\u0004\u0019A\u0011)\u0007\u0005md\u0005\u0003\u0004+\u0003o\u0002\ra\u000b\u0005\u0007g\u0005]\u0004\u0019A\u0016\t\rU\n9\b1\u0001,\u0011\u00199\u0014q\u000fa\u0001W!1\u0011(a\u001eA\u0002-BaARA<\u0001\u0004Y\u0003B\u0002(\u0002x\u0001\u00071\u0006\u0003\u0004W\u0003o\u0002\ra\u0016")
public class LoghubInputDStream
extends ReceiverInputDStream<byte[]> {
    private final String logServiceProject;
    private final String logStoreName;
    private final String loghubConsumerGroupName;
    private final String loghubInstanceNameBase;
    private String loghubEndpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private final StorageLevel storageLevel;
    private final LogHubCursorPosition cursorPosition;
    private final int mLoghubCursorStartTime;
    private final boolean mConsumeInOrder;
    private final long mHeartBeatIntervalMillis;
    private final long dataFetchIntervalMillis;
    private final long batchInterval;
    private String securityToken;
    private transient Client slsClient;
    private volatile transient boolean bitmap$trans$0;

    private Client slsClient$lzycompute() {
        LoghubInputDStream loghubInputDStream = this;
        synchronized (loghubInputDStream) {
            if (!this.bitmap$trans$0) {
                Client client;
                if (this.accessKeyId() == null || this.accessKeySecret() == null) {
                    String string;
                    this.accessKeyId_$eq(MetaClient.getRoleAccessKeyId());
                    this.accessKeySecret_$eq(MetaClient.getRoleAccessKeySecret());
                    this.securityToken_$eq(MetaClient.getRoleSecurityToken());
                    if (this.loghubEndpoint() == null) {
                        String region = MetaClient.getClusterRegionName();
                        String nType = MetaClient.getClusterNetworkType();
                        String endpointBase = EndpointEnum.getEndpoint((String)"log", (String)region, (String)nType);
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logServiceProject, endpointBase}));
                    } else {
                        string = this.loghubEndpoint();
                    }
                    this.loghubEndpoint_$eq(string);
                    Client client2 = new Client(this.loghubEndpoint(), this.accessKeyId(), this.accessKeySecret());
                    client2.SetSecurityToken(this.securityToken());
                    client = client2;
                } else {
                    client = new Client(this.loghubEndpoint(), this.accessKeyId(), this.accessKeySecret());
                }
                this.slsClient = client;
                this.bitmap$trans$0 = true;
            }
            return this.slsClient;
        }
    }

    public String loghubEndpoint() {
        return this.loghubEndpoint;
    }

    public void loghubEndpoint_$eq(String x$1) {
        this.loghubEndpoint = x$1;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public void accessKeyId_$eq(String x$1) {
        this.accessKeyId = x$1;
    }

    public String accessKeySecret() {
        return this.accessKeySecret;
    }

    public void accessKeySecret_$eq(String x$1) {
        this.accessKeySecret = x$1;
    }

    public boolean mConsumeInOrder() {
        return this.mConsumeInOrder;
    }

    public long mHeartBeatIntervalMillis() {
        return this.mHeartBeatIntervalMillis;
    }

    public long dataFetchIntervalMillis() {
        return this.dataFetchIntervalMillis;
    }

    public long batchInterval() {
        return this.batchInterval;
    }

    public String securityToken() {
        return this.securityToken;
    }

    public void securityToken_$eq(String x$1) {
        this.securityToken = x$1;
    }

    public Client slsClient() {
        return this.bitmap$trans$0 ? this.slsClient : this.slsClient$lzycompute();
    }

    public Receiver<byte[]> getReceiver() {
        return new LoghubReceiver(this.mConsumeInOrder(), this.mHeartBeatIntervalMillis(), this.dataFetchIntervalMillis(), this.batchInterval(), this.logServiceProject, this.logStoreName, this.loghubConsumerGroupName, this.loghubInstanceNameBase, this.loghubEndpoint(), this.accessKeyId(), this.accessKeySecret(), this.storageLevel, this.cursorPosition, this.mLoghubCursorStartTime);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoghubInputDStream(StreamingContext _ssc, String logServiceProject, String logStoreName, String loghubConsumerGroupName, String loghubInstanceNameBase, String loghubEndpoint, String accessKeyId, String accessKeySecret, StorageLevel storageLevel, LogHubCursorPosition cursorPosition, int mLoghubCursorStartTime, boolean forceSpecial) {
        BoxedUnit boxedUnit;
        this.logServiceProject = logServiceProject;
        this.logStoreName = logStoreName;
        this.loghubConsumerGroupName = loghubConsumerGroupName;
        this.loghubInstanceNameBase = loghubInstanceNameBase;
        this.loghubEndpoint = loghubEndpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.storageLevel = storageLevel;
        this.cursorPosition = cursorPosition;
        this.mLoghubCursorStartTime = mLoghubCursorStartTime;
        super(_ssc, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        this.mConsumeInOrder = _ssc.sc().getConf().getBoolean("spark.logservice.fetch.inOrder", true);
        this.mHeartBeatIntervalMillis = _ssc.sc().getConf().getLong("spark.logservice.heartbeat.interval.millis", 30000L);
        this.dataFetchIntervalMillis = _ssc.sc().getConf().getLong("spark.logservice.fetch.interval.millis", 200L);
        this.batchInterval = _ssc.graph().batchDuration().milliseconds();
        this.securityToken = null;
        if (forceSpecial && cursorPosition.toString().equals(LogHubCursorPosition.SPECIAL_TIMER_CURSOR.toString())) {
            try {
                boxedUnit = this.slsClient().DeleteConsumerGroup(logServiceProject, logStoreName, loghubConsumerGroupName);
                return;
            }
            catch (Exception exception) {
                if (this.securityToken() == null) {
                    this.logError((Function0)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete consumer group, ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.getMessage()}));
                        }
                        {
                            this.e$1 = e$1;
                        }
                    }, exception);
                    throw exception;
                }
                try {
                    this.accessKeyId_$eq(MetaClient.getRoleAccessKeyId());
                    this.accessKeySecret_$eq(MetaClient.getRoleAccessKeySecret());
                    this.securityToken_$eq(MetaClient.getRoleSecurityToken());
                    Client client = new Client(this.loghubEndpoint(), this.accessKeyId(), this.accessKeySecret());
                    client.SetSecurityToken(this.securityToken());
                    boxedUnit = client.DeleteConsumerGroup(logServiceProject, logStoreName, loghubConsumerGroupName);
                    return;
                }
                catch (Exception exception2) {
                    this.logError((Function0)new Serializable(this, exception2){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete consumer group, ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$2.getMessage()}));
                        }
                        {
                            this.e$2 = e$2;
                        }
                    }, exception2);
                    throw exception2;
                }
            }
        }
        boxedUnit = BoxedUnit.UNIT;
    }

    public LoghubInputDStream(StreamingContext _ssc, String logServiceProject, String logStoreName, String loghubConsumerGroupName, String loghubInstanceNameBase, String loghubEndpoint, String accessKeyId, String accessKeySecret, StorageLevel storageLevel) {
        this(_ssc, logServiceProject, logStoreName, loghubConsumerGroupName, loghubInstanceNameBase, loghubEndpoint, accessKeyId, accessKeySecret, storageLevel, LogHubCursorPosition.END_CURSOR, -1, false);
    }
}

