/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.aliyun.ons;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.ons.api.Message;
import java.util.Properties;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.aliyun.ons.OnsInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class OnsUtils$ {
    public static final OnsUtils$ MODULE$;

    static {
        new OnsUtils$();
    }

    @Experimental
    public ReceiverInputDStream<byte[]> createStream(StreamingContext ssc, Properties properties, StorageLevel storageLevel, Function1<Message, byte[]> func) {
        return (ReceiverInputDStream)ssc.withNamedScope("ons stream", (Function0)new Serializable(ssc, properties, storageLevel, func){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$1;
            private final Properties properties$1;
            private final StorageLevel storageLevel$1;
            private final Function1 func$1;

            public final OnsInputDStream apply() {
                return new OnsInputDStream(this.ssc$1, this.properties$1, this.storageLevel$1, (Function1<Message, byte[]>)this.func$1);
            }
            {
                this.ssc$1 = ssc$1;
                this.properties$1 = properties$1;
                this.storageLevel$1 = storageLevel$1;
                this.func$1 = func$1;
            }
        });
    }

    @Experimental
    public ReceiverInputDStream<byte[]> createStream(StreamingContext ssc, String consumerId, String topic, String tags, String accessKeyId, String accessKeySecret, StorageLevel storageLevel, Function1<Message, byte[]> func) {
        return (ReceiverInputDStream)ssc.withNamedScope("ons stream", (Function0)new Serializable(ssc, consumerId, topic, tags, accessKeyId, accessKeySecret, storageLevel, func){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$2;
            private final String consumerId$1;
            private final String topic$1;
            private final String tags$1;
            private final String accessKeyId$1;
            private final String accessKeySecret$1;
            private final StorageLevel storageLevel$2;
            private final Function1 func$2;

            public final ReceiverInputDStream<byte[]> apply() {
                Properties properties = new Properties();
                properties.setProperty("ConsumerId", this.consumerId$1);
                properties.setProperty("topic", this.topic$1);
                properties.setProperty("subExpression", this.tags$1);
                properties.setProperty("AccessKey", this.accessKeyId$1);
                properties.setProperty("SecretKey", this.accessKeySecret$1);
                return OnsUtils$.MODULE$.createStream(this.ssc$2, properties, this.storageLevel$2, (Function1<Message, byte[]>)this.func$2);
            }
            {
                this.ssc$2 = ssc$2;
                this.consumerId$1 = consumerId$1;
                this.topic$1 = topic$1;
                this.tags$1 = tags$1;
                this.accessKeyId$1 = accessKeyId$1;
                this.accessKeySecret$1 = accessKeySecret$1;
                this.storageLevel$2 = storageLevel$2;
                this.func$2 = func$2;
            }
        });
    }

    @Experimental
    public DStream<byte[]> createStreams(StreamingContext ssc, Tuple3<String, String, String>[] consumerIdTopicTags, String accessKeyId, String accessKeySecret, StorageLevel storageLevel, Function1<Message, byte[]> func) {
        Map invalidTuples1 = (Map)Predef$.MODULE$.refArrayOps((Object[])consumerIdTopicTags).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple3<String, String, String> e) {
                return new Tuple2(e._1(), e._2());
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<String, String>, Tuple3<String, String, String>[]> e) {
                return ((Tuple3[])e._2()).length > 1;
            }
        });
        Map invalidTuples2 = (Map)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])consumerIdTopicTags).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple3<String, String, String> e) {
                return new Tuple2(e._1(), e._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> e) {
                return (String)e._1();
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Tuple2<String, String>[]> e) {
                return ((Tuple2[])e._2()).length > 1;
            }
        });
        if (invalidTuples1.size() > 1 || invalidTuples2.size() > 1) {
            throw new RuntimeException("Inconsistent consumer subscription.");
        }
        return ssc.union((Seq)Predef$.MODULE$.refArrayOps((Object[])consumerIdTopicTags).map((Function1)new Serializable(ssc, accessKeyId, accessKeySecret, storageLevel, func){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$3;
            private final String accessKeyId$2;
            private final String accessKeySecret$2;
            private final StorageLevel storageLevel$3;
            private final Function1 func$4;

            public final ReceiverInputDStream<byte[]> apply(Tuple3<String, String, String> x0$1) {
                Tuple3<String, String, String> tuple3 = x0$1;
                if (tuple3 != null) {
                    String consumerId = (String)tuple3._1();
                    String topic = (String)tuple3._2();
                    String tags = (String)tuple3._3();
                    ReceiverInputDStream<byte[]> receiverInputDStream = OnsUtils$.MODULE$.createStream(this.ssc$3, consumerId, topic, tags, this.accessKeyId$2, this.accessKeySecret$2, this.storageLevel$3, (Function1<Message, byte[]>)this.func$4);
                    return receiverInputDStream;
                }
                throw new MatchError(tuple3);
            }
            {
                this.ssc$3 = ssc$3;
                this.accessKeyId$2 = accessKeyId$2;
                this.accessKeySecret$2 = accessKeySecret$2;
                this.storageLevel$3 = storageLevel$3;
                this.func$4 = func$4;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    @Experimental
    public JavaReceiverInputDStream<byte[]> createStream(JavaStreamingContext jssc, String consumerId, String topic, String tags, String accessKeyId, String accessKeySecret, StorageLevel storageLevel, Function<Message, byte[]> func) {
        Properties properties = new Properties();
        properties.setProperty("ConsumerId", consumerId);
        properties.setProperty("topic", topic);
        properties.setProperty("subExpression", tags);
        properties.setProperty("AccessKey", accessKeyId);
        properties.setProperty("SecretKey", accessKeySecret);
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), properties, storageLevel, (Function1<Message, byte[]>)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function func$3;

            public final byte[] apply(Message msg) {
                return (byte[])this.func$3.call((Object)msg);
            }
            {
                this.func$3 = func$3;
            }
        }), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public byte[] org$apache$spark$streaming$aliyun$ons$OnsUtils$$extractMessage(Message msg) {
        return JSON.toJSONBytes((Object)msg, (SerializerFeature[])new SerializerFeature[0]);
    }

    public Message toMessage(byte[] msgJson) {
        return (Message)JSON.parseObject((String)new String(msgJson), Message.class);
    }

    @Experimental
    public JavaReceiverInputDStream<byte[]> createDefaultStreams(JavaStreamingContext jssc, String consumerId, String topic, String tags, String accessKeyId, String accessKeySecret, StorageLevel storageLevel) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), consumerId, topic, tags, accessKeyId, accessKeySecret, storageLevel, (Function1<Message, byte[]>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Message msg) {
                return OnsUtils$.MODULE$.org$apache$spark$streaming$aliyun$ons$OnsUtils$$extractMessage(msg);
            }
        }), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    private OnsUtils$() {
        MODULE$ = this;
    }
}

